/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.operation;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.remote.GetLogMessagesOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class CorrectRevisionOperation
extends AbstractNonLockingOperation {
    protected IRepositoryResource[] repositoryResources;
    protected long[] knownRevisions;
    protected GetLogMessagesOperation[] msgsOps;
    protected IResource[] resources;

    public CorrectRevisionOperation(GetLogMessagesOperation msgsOp, IRepositoryResource repositoryResource, long knownRevision, IResource resource) {
        GetLogMessagesOperation[] getLogMessagesOperationArray;
        if (msgsOp == null) {
            getLogMessagesOperationArray = null;
        } else {
            GetLogMessagesOperation[] getLogMessagesOperationArray2 = new GetLogMessagesOperation[1];
            getLogMessagesOperationArray = getLogMessagesOperationArray2;
            getLogMessagesOperationArray2[0] = msgsOp;
        }
        this(getLogMessagesOperationArray, new IRepositoryResource[]{repositoryResource}, new long[]{knownRevision}, new IResource[]{resource});
    }

    public CorrectRevisionOperation(GetLogMessagesOperation[] msgsOps, IRepositoryResource[] repositoryResources, long[] knownRevisions, IResource[] resources) {
        super("Operation.CorrectRevision");
        this.repositoryResources = repositoryResources;
        this.knownRevisions = knownRevisions;
        this.msgsOps = msgsOps;
        this.resources = resources;
    }

    protected void runImpl(final IProgressMonitor monitor) throws Exception {
        boolean hasWarning = false;
        int i = 0;
        while (i < this.repositoryResources.length) {
            if (!this.repositoryResources[i].exists() && this.resources != null && this.resources[i] != null && this.resources[i].getType() != 4) {
                ILocalResource parent = SVNRemoteStorage.instance().asLocalResource((IResource)this.resources[i].getParent());
                ILocalResource self = SVNRemoteStorage.instance().asLocalResource(this.resources[i]);
                if (parent != null && self != null) {
                    boolean switchedStateEquals;
                    boolean bl = switchedStateEquals = (parent.getChangeMask() & 8) == (self.getChangeMask() & 8);
                    if (switchedStateEquals) {
                        long selfRevision;
                        long revision;
                        long parentRevision = parent.getRevision();
                        long l = revision = parentRevision > (selfRevision = self.getRevision()) ? parentRevision : selfRevision;
                        if (revision != -1L) {
                            this.repositoryResources[i].setPegRevision(Revision.getInstance((long)revision));
                        }
                    } else {
                        this.repositoryResources[i].setPegRevision(Revision.getInstance((long)self.getRevision()));
                    }
                }
            }
            if (!this.repositoryResources[i].exists() && this.knownRevisions[i] != -1L) {
                hasWarning = true;
                Revision rev = Revision.getInstance((long)this.knownRevisions[i]);
                this.repositoryResources[i].setSelectedRevision(rev);
                this.repositoryResources[i].setPegRevision(rev);
                if (this.msgsOps != null) {
                    this.msgsOps[i].setSelectedRevision(rev);
                }
            }
            ++i;
        }
        if (hasWarning) {
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                public void run() {
                    boolean one = CorrectRevisionOperation.this.repositoryResources.length == 1;
                    MessageDialog dlg = new MessageDialog(UIMonitorUtility.getShell(), CorrectRevisionOperation.this.getOperationResource(one ? "Title.Single" : "Title.Multi"), null, CorrectRevisionOperation.this.getOperationResource(one ? "Message.Single" : "Message.Multi"), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                    if (dlg.open() != 0) {
                        monitor.setCanceled(true);
                    }
                }
            });
        }
    }
}

