/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.operation;

import java.text.MessageFormat;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.ISVNProgressMonitor;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryResourceProvider;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.compare.TwoWayResourceCompareInput;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class CompareRepositoryResourcesOperation
extends AbstractNonLockingOperation {
    protected IRepositoryResource left;
    protected IRepositoryResource right;
    protected IRepositoryResourceProvider provider;

    public CompareRepositoryResourcesOperation(IRepositoryResource left, IRepositoryResource right) {
        super("Operation.CompareRepository");
        this.left = left;
        this.right = right;
    }

    public CompareRepositoryResourcesOperation(IRepositoryResourceProvider provider) {
        this(null, null);
        this.provider = provider;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        if (this.provider != null) {
            IRepositoryResource[] toCompare = this.provider.getRepositoryResources();
            this.left = toCompare[0];
            this.right = toCompare[1];
        }
        long rev1 = this.left.getRevision();
        long rev2 = this.right.getRevision();
        if (rev2 > rev1) {
            IRepositoryResource tmp = this.left;
            this.left = this.right;
            this.right = tmp;
        }
        IRepositoryLocation location = this.left.getRepositoryLocation();
        final ISVNClientWrapper proxy = location.acquireSVNProxy();
        final Status[][] statuses = new Status[1][];
        this.protectStep(new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                statuses[0] = proxy.diffStatus(SVNUtility.encodeURL((String)CompareRepositoryResourcesOperation.this.right.getUrl()), CompareRepositoryResourcesOperation.this.right.getPegRevision(), CompareRepositoryResourcesOperation.this.right.getSelectedRevision(), SVNUtility.encodeURL((String)CompareRepositoryResourcesOperation.this.left.getUrl()), CompareRepositoryResourcesOperation.this.left.getPegRevision(), CompareRepositoryResourcesOperation.this.left.getSelectedRevision(), true, false, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)CompareRepositoryResourcesOperation.this, monitor, null, false));
            }
        }, monitor, 2);
        location.releaseSVNProxy(proxy);
        if (statuses[0] != null && !monitor.isCanceled()) {
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    CompareConfiguration cc = new CompareConfiguration();
                    cc.setProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", (Object)Boolean.FALSE);
                    TwoWayResourceCompareInput compare = new TwoWayResourceCompareInput(cc, CompareRepositoryResourcesOperation.this.left, CompareRepositoryResourcesOperation.this.right, statuses[0]);
                    compare.initialize(monitor);
                    UIMonitorUtility.getDisplay().syncExec(new Runnable(this, compare){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ TwoWayResourceCompareInput val$compare;
                        {
                            this.this$1 = var1_1;
                            this.val$compare = twoWayResourceCompareInput;
                        }

                        public void run() {
                            CompareUI.openCompareEditor((CompareEditorInput)this.val$compare);
                        }
                    });
                }
            }, monitor, 2);
        }
    }

    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), this.left.getName(), this.right.getName());
    }
}

