/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.history;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.events.IResourceStatesListener;
import org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.history.HistoryViewImpl;
import org.polarion.team.svn.ui.history.IViewInfoProvider;
import org.polarion.team.svn.ui.repository.model.RepositoryLocation;
import org.polarion.team.svn.ui.repository.model.RepositoryResource;

public class SVNHistoryPage
extends HistoryPage
implements IViewInfoProvider,
IResourceStatesListener {
    public static final String VIEW_ID = "org.eclipse.team.ui.GenericHistoryView";
    protected HistoryViewImpl viewImpl;
    static /* synthetic */ Class class$0;

    public SVNHistoryPage(Object input) {
        SVNRemoteStorage sVNRemoteStorage = SVNRemoteStorage.instance();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sVNRemoteStorage.addResourceStatesListener((Class)clazz, (IResourceStatesListener)this);
    }

    public void resourcesStateChanged(ResourceStatesChangedEvent event) {
        if (this.getResource() == null) {
            return;
        }
        if (event.contains(this.getResource()) || event.contains((IResource)this.getResource().getProject())) {
            if (!this.getResource().exists() || !FileUtility.isConnected((IResource)this.getResource())) {
                this.disconnectView();
            } else {
                ILocalResource local = SVNRemoteStorage.instance().asLocalResource(this.getResource());
                if (local == null || IStateFilter.SF_NONVERSIONED.accept(this.getResource(), local.getStatus(), local.getChangeMask())) {
                    this.disconnectView();
                }
            }
        }
    }

    public void dispose() {
        SVNRemoteStorage sVNRemoteStorage = SVNRemoteStorage.instance();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sVNRemoteStorage.removeResourceStatesListener((Class)clazz, (IResourceStatesListener)this);
        if (this.viewImpl != null) {
            this.viewImpl.dispose();
        }
        super.dispose();
    }

    public int getOptions() {
        if (this.viewImpl != null) {
            return this.viewImpl.getOptions();
        }
        return 0;
    }

    public void setOptions(int mask, int values) {
        if (this.viewImpl != null) {
            this.viewImpl.setOptions(mask, values);
        }
    }

    public IResource getResource() {
        if (this.viewImpl != null) {
            return this.viewImpl.getResource();
        }
        return null;
    }

    public IRepositoryResource getRepositoryResource() {
        if (this.viewImpl != null) {
            return this.viewImpl.getRepositoryResource();
        }
        return null;
    }

    public boolean inputSet() {
        if (this.viewImpl == null) {
            return SVNHistoryPage.isValidData(this.getInput());
        }
        if (this.getInput() instanceof IResource) {
            IResource resource = this.isInputValid() ? (IResource)this.getInput() : null;
            this.viewImpl.showHistory(resource, true);
            return true;
        }
        if (this.getInput() instanceof IRepositoryResource) {
            this.viewImpl.showHistory((IRepositoryResource)this.getInput(), true);
            return true;
        }
        if (this.getInput() instanceof RepositoryResource) {
            this.viewImpl.showHistory(((RepositoryResource)this.getInput()).getRepositoryResource(), true);
            return true;
        }
        if (this.getInput() instanceof RepositoryLocation) {
            this.viewImpl.showHistory(((RepositoryLocation)this.getInput()).getRepositoryResource(), true);
            return true;
        }
        return false;
    }

    private boolean isInputValid() {
        Object object = this.getInput();
        if (object == null) {
            return false;
        }
        if (object instanceof IResource) {
            return FileUtility.checkForResourcesPresence((IResource[])new IResource[]{(IResource)object}, (IStateFilter)IStateFilter.SF_ONREPOSITORY, (int)0);
        }
        return object instanceof IRepositoryResource || object instanceof RepositoryResource || object instanceof RepositoryLocation;
    }

    public void createControl(Composite parent) {
        this.viewImpl = new HistoryViewImpl(null, null, this);
        IActionBars actionBars = this.getActionBars();
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.add((IContributionItem)new Separator("MainGroup"));
        tbm.add((IContributionItem)new Separator("SecondGroup"));
        this.viewImpl.createPartControl(parent);
        this.inputSet();
    }

    public Control getControl() {
        if (this.viewImpl != null) {
            return this.viewImpl.getControl();
        }
        return null;
    }

    public void setFocus() {
    }

    public String getDescription() {
        if (this.viewImpl != null) {
            return this.viewImpl.getResourceLabel();
        }
        return null;
    }

    public String getName() {
        if (this.viewImpl != null) {
            if (this.viewImpl.getResource() != null) {
                return this.viewImpl.getResource().getName();
            }
            if (this.viewImpl.getRepositoryResource() != null) {
                return this.viewImpl.getRepositoryResource().getName();
            }
        }
        return null;
    }

    public boolean isValidInput(Object object) {
        return SVNHistoryPage.isValidData(object);
    }

    public static boolean isValidData(Object object) {
        return object instanceof IResource && FileUtility.isConnected((IResource)((IResource)object)) || object instanceof IRepositoryResource || object instanceof RepositoryResource || object instanceof RepositoryLocation;
    }

    public void refresh() {
        if (this.viewImpl != null) {
            this.viewImpl.refresh();
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IActionBars getActionBars() {
        return this.getHistoryPageSite().getWorkbenchPageSite().getActionBars();
    }

    public IWorkbenchPartSite getPartSite() {
        IWorkbenchPart part = this.getHistoryPageSite().getPart();
        if (part == null) {
            return null;
        }
        IWorkbenchPartSite site = part.getSite();
        while (site == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            site = part.getSite();
        }
        return site;
    }

    public void setDescription(String description) {
    }

    public void selectRevision(long revision) {
        if (this.viewImpl != null) {
            this.viewImpl.selectRevision(revision);
        }
    }

    protected void disconnectView() {
        if (this.viewImpl != null) {
            this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    SVNHistoryPage.this.viewImpl.showHistory((IResource)null, false);
                }
            });
        }
    }
}

