/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.history;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.history.AffectedPathNode;

public class AffectedPathsContentProvider
implements ITreeContentProvider {
    protected AffectedPathNode root;

    public void initialize(String[][] affectedPaths, Collection relatedPathPrefixes, Collection relatedParents, long currentRevision) {
        this.root = new AffectedPathNode(SVNTeamUIPlugin.instance().getResource("AffectedPathsContentProvider.RootName"), null, null);
        if (affectedPaths == null) {
            return;
        }
        int i = 0;
        while (i < affectedPaths.length) {
            String[] row = affectedPaths[i];
            this.processPath(row, relatedPathPrefixes, relatedParents);
            ++i;
        }
        this.doCompress(this.root);
        this.refreshStatuses(this.root);
    }

    public boolean hasChildren(Object element) {
        AffectedPathNode node = (AffectedPathNode)element;
        return node.hasChildren();
    }

    public Object[] getChildren(Object parentElement) {
        AffectedPathNode parentNode = (AffectedPathNode)parentElement;
        return parentNode.getChildren().toArray(new AffectedPathNode[parentNode.getChildren().size()]);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object getParent(Object element) {
        return ((AffectedPathNode)element).getParent();
    }

    public Object[] getElements(Object inputElement) {
        return new Object[]{this.root};
    }

    public AffectedPathNode getRoot() {
        return this.root;
    }

    protected void processPath(String[] affectedPath, Collection relatedPathPrefixes, Collection relatedParents) {
        String fullPath = String.valueOf(affectedPath[2]) + (affectedPath[2].length() > 0 ? "/" : "") + affectedPath[1];
        if (!this.isRelatedPath(fullPath, relatedPathPrefixes) && !this.isRelatedParent(fullPath, relatedParents)) {
            return;
        }
        StringTokenizer st = new StringTokenizer(fullPath, "/");
        AffectedPathNode node = null;
        AffectedPathNode parent = this.root;
        AffectedPathNode nextToLast = this.root;
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            node = parent.findByName(name);
            if (node == null) {
                node = new AffectedPathNode(name, parent, name.equals(affectedPath[1]) ? affectedPath[0] : null);
                parent.addChild(node);
            } else if (name.equals(affectedPath[1])) {
                node.setStatus(affectedPath[0]);
            }
            nextToLast = parent;
            parent = node;
        }
        nextToLast.addData(affectedPath);
        if (!(node == null || node.getChildren() != null && node.getChildren().size() != 0 || node.getPathData() != null && node.getPathData().length != 0)) {
            nextToLast.removeChild(node);
        }
    }

    protected boolean isRelatedParent(String fullPath, Collection relatedParents) {
        return relatedParents == null || relatedParents.contains(fullPath);
    }

    protected boolean isRelatedPath(String fullPath, Collection relatedPathPrefixes) {
        if (relatedPathPrefixes == null) {
            return true;
        }
        Iterator it = relatedPathPrefixes.iterator();
        while (it.hasNext()) {
            String prefix = (String)it.next();
            if (!fullPath.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected void doCompress(AffectedPathNode node) {
        List children = node.getChildren();
        if (node.getParent() == null) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                this.doCompress((AffectedPathNode)it.next());
            }
            return;
        }
        if (children.size() == 0) {
            return;
        }
        if (children.size() == 1) {
            AffectedPathNode nodeChild = (AffectedPathNode)children.get(0);
            if (node.getData() != null && node.getData().length > 0) {
                this.doCompress(nodeChild);
                return;
            }
            node.setName(String.valueOf(node.getName()) + "/" + nodeChild.getName());
            List lowerChildren = nodeChild.getChildren();
            Iterator it = lowerChildren.iterator();
            while (it.hasNext()) {
                ((AffectedPathNode)it.next()).setParent(node);
            }
            node.setChildren(lowerChildren);
            String[][] data = nodeChild.getData();
            int i = 0;
            while (i < data.length) {
                node.addData(data[i]);
                ++i;
            }
            this.doCompress(node);
            Iterator it2 = lowerChildren.iterator();
            while (it2.hasNext()) {
                this.doCompress((AffectedPathNode)it2.next());
            }
        } else {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                this.doCompress((AffectedPathNode)it.next());
            }
        }
    }

    protected void refreshStatuses(AffectedPathNode node) {
        List children = node.getChildren();
        if (children.size() == 0) {
            return;
        }
        String[][] affectedPathData = node.getData();
        if (affectedPathData != null && affectedPathData.length > 0) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                AffectedPathNode currentNode = (AffectedPathNode)iter.next();
                int i = 0;
                while (i < affectedPathData.length) {
                    String[] affectedPath = affectedPathData[i];
                    if (currentNode.getName().equals(affectedPath[1])) {
                        currentNode.setStatus(affectedPath[0]);
                        break;
                    }
                    ++i;
                }
                this.refreshStatuses(currentNode);
            }
        } else {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                this.refreshStatuses((AffectedPathNode)iter.next());
            }
        }
    }
}

