/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.history;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AffectedPathNode {
    protected String name;
    protected List children = new ArrayList();
    protected AffectedPathNode parent;
    protected List data = null;
    protected String status;

    public AffectedPathNode(String name, AffectedPathNode parent, String status) {
        this.name = name;
        this.parent = parent;
        this.data = new ArrayList();
        this.status = status;
    }

    public String getName() {
        return this.name;
    }

    public AffectedPathNode findByName(String name) {
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            AffectedPathNode node = (AffectedPathNode)it.next();
            if (!node.getName().equals(name)) continue;
            return node;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public AffectedPathNode getParent() {
        return this.parent;
    }

    public List getChildren() {
        return this.children;
    }

    public boolean addChild(AffectedPathNode child) {
        if (this.children.contains(child)) {
            return false;
        }
        return this.children.add(child);
    }

    public void addChildren(List children) {
        Iterator it = children.iterator();
        while (it.hasNext()) {
            this.addChild((AffectedPathNode)it.next());
        }
    }

    public boolean removeChild(AffectedPathNode child) {
        if (this.children.contains(child)) {
            return this.children.remove(child);
        }
        return false;
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof AffectedPathNode)) {
            return false;
        }
        AffectedPathNode node2 = (AffectedPathNode)arg0;
        if (this.parent == null) {
            return node2.parent == null;
        }
        return this.parent.equals(node2.parent) && this.getName().equals(node2.getName());
    }

    public int hashCode() {
        int h = 17;
        h += 31 * (this.parent != null ? this.parent.hashCode() : 0);
        return h += 31 * this.name.hashCode();
    }

    public String[][] getData() {
        return (String[][])this.data.toArray((T[])new String[this.data.size()][]);
    }

    protected List getPathDataImpl(List result) {
        if (this.data != null) {
            result.addAll(this.data);
        }
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            ((AffectedPathNode)it.next()).getPathDataImpl(result);
        }
        return result;
    }

    public void addData(String[] data) {
        if (!this.data.contains(data)) {
            this.data.add(data);
        }
    }

    public String[][] getPathData() {
        List tmp = this.getPathDataImpl(new ArrayList());
        return (String[][])tmp.toArray((T[])new String[tmp.size()][]);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParent(AffectedPathNode parent) {
        this.parent = parent;
    }

    public void setChildren(List children) {
        this.children = children;
    }

    public String getFullPath() {
        String path = "";
        if (this.parent != null) {
            path = String.valueOf(this.parent.getFullPath()) + "/" + this.name;
        }
        return path;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}

