/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.extension.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.ui.extension.factory.ICommentView;
import org.polarion.team.svn.ui.panel.local.CommitPanel;
import org.polarion.team.svn.ui.properties.bugtraq.BugtraqModel;
import org.polarion.team.svn.ui.properties.bugtraq.IssueList;

public class DefaultCommentView
implements ICommentView {
    protected StyledText multilineComment;
    protected Cursor handCursor;
    protected Cursor busyCursor;
    protected Color black;
    protected Color blue;
    protected boolean mouseDown;
    protected boolean dragEvent;
    protected BugtraqModel model;
    protected IssueList linkList = new IssueList();

    public void createCommentView(Composite parent) {
        this.createCommentView(parent, 2626);
    }

    public void createCommentView(Composite parent, int style) {
        this.multilineComment = new StyledText(parent, style);
        this.multilineComment.setEditable(false);
        this.multilineComment.setBackground(this.multilineComment.getBackground());
        this.handCursor = new Cursor((Device)parent.getDisplay(), 21);
        this.busyCursor = new Cursor((Device)parent.getDisplay(), 1);
        this.blue = new Color((Device)parent.getDisplay(), 0, 0, 192);
        this.black = new Color((Device)parent.getDisplay(), 2, 200, 30);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DefaultCommentView.this.blue.dispose();
                DefaultCommentView.this.black.dispose();
            }
        });
        this.multilineComment.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                DefaultCommentView.this.mouseDown = true;
            }

            public void mouseUp(MouseEvent e) {
                DefaultCommentView.this.mouseDown = false;
                StyledText text = (StyledText)e.widget;
                int offset = text.getCaretOffset();
                if (DefaultCommentView.this.dragEvent) {
                    DefaultCommentView.this.dragEvent = false;
                    if (DefaultCommentView.this.linkList.isIssueAt(offset)) {
                        text.setCursor(DefaultCommentView.this.handCursor);
                        text.getStyleRangeAtOffset((int)offset).background = DefaultCommentView.this.blue;
                    }
                } else if (DefaultCommentView.this.linkList.isIssueAt(offset)) {
                    text.setCursor(DefaultCommentView.this.busyCursor);
                    String url = DefaultCommentView.this.model.getResultingURL(DefaultCommentView.this.linkList.getIssueAt(offset));
                    if (url != null) {
                        Program.launch((String)url);
                    }
                    text.setCursor(null);
                    text.getStyleRangeAtOffset((int)offset).background = DefaultCommentView.this.black;
                }
            }
        });
        this.multilineComment.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (DefaultCommentView.this.mouseDown) {
                    if (!DefaultCommentView.this.dragEvent) {
                        StyledText text = (StyledText)e.widget;
                        text.setCursor(null);
                    }
                    DefaultCommentView.this.dragEvent = true;
                    return;
                }
                StyledText text = (StyledText)e.widget;
                int offset = -1;
                try {
                    offset = text.getOffsetAtLocation(new Point(e.x, e.y));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (offset == -1) {
                    text.setCursor(null);
                } else if (DefaultCommentView.this.linkList.isIssueAt(offset)) {
                    text.setCursor(DefaultCommentView.this.handCursor);
                    text.getStyleRangeAtOffset((int)offset).background = DefaultCommentView.this.blue;
                    DefaultCommentView.this.multilineComment.redraw();
                } else {
                    text.setCursor(null);
                }
            }
        });
        this.multilineComment.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DefaultCommentView.this.linkList.getIssues().clear();
                StyledText text = (StyledText)e.getSource();
                if (DefaultCommentView.this.getModel().getMessage() != null) {
                    DefaultCommentView.this.linkList.parseMessage(text.getText(), DefaultCommentView.this.getModel());
                    ArrayList<StyleRange> styledRanges = new ArrayList<StyleRange>();
                    Iterator iter = DefaultCommentView.this.linkList.getIssues().iterator();
                    while (iter.hasNext()) {
                        IssueList.Issue issue = (IssueList.Issue)iter.next();
                        StyleRange range = new StyleRange();
                        range.start = issue.getStart();
                        range.length = issue.getEnd() - issue.getStart();
                        range.foreground = DefaultCommentView.this.blue;
                        range.underline = true;
                        styledRanges.add(range);
                    }
                    text.setStyleRanges(styledRanges.toArray(new StyleRange[styledRanges.size()]));
                }
            }
        });
        this.multilineComment.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DefaultCommentView.this.dispose();
            }
        });
    }

    public void usedFor(IResource resource) {
        CommitPanel.GetBugTraqPropertiesModelOperation bugtraqOp = new CommitPanel.GetBugTraqPropertiesModelOperation(new IResource[]{resource});
        bugtraqOp.run((IProgressMonitor)new NullProgressMonitor());
        this.model = bugtraqOp.getBugtraqModel();
    }

    public void usedFor(IRepositoryResource resource) {
    }

    public void setComment(String comment) {
        this.multilineComment.setText(comment);
    }

    protected void dispose() {
        if (this.busyCursor != null) {
            this.busyCursor.dispose();
        }
        if (this.handCursor != null) {
            this.handCursor.dispose();
        }
    }

    protected BugtraqModel getModel() {
        if (this.model != null) {
            return this.model;
        }
        return new BugtraqModel();
    }
}

