/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.extension;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.polarion.team.svn.core.operation.LoggedOperation;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.decorator.IDecorationFilter;
import org.polarion.team.svn.ui.extension.factory.ICheckoutFactory;
import org.polarion.team.svn.ui.extension.factory.ICommitActionFactory;
import org.polarion.team.svn.ui.extension.factory.IHistoryViewFactory;
import org.polarion.team.svn.ui.extension.factory.IMailSettingsProvider;
import org.polarion.team.svn.ui.extension.factory.IPredefinedPropertySet;
import org.polarion.team.svn.ui.extension.factory.IShareProjectFactory;
import org.polarion.team.svn.ui.extension.factory.ISynchronizeViewActionContributor;
import org.polarion.team.svn.ui.extension.impl.DefaultCheckoutFactory;
import org.polarion.team.svn.ui.extension.impl.DefaultCommitActionFactory;
import org.polarion.team.svn.ui.extension.impl.DefaultDecorationFilter;
import org.polarion.team.svn.ui.extension.impl.DefaultHistoryViewFactory;
import org.polarion.team.svn.ui.extension.impl.DefaultShareProjectFactory;
import org.polarion.team.svn.ui.extension.impl.DefaultSynchronizeViewActionContributor;
import org.polarion.team.svn.ui.extension.impl.PredefinedPropertySet;

public class ExtensionsManager {
    private static final String UI_EXTENSION_NAMESPACE = "org.polarion.team.svn.ui";
    private ICommitActionFactory currentCommitFactory;
    private IHistoryViewFactory currentMessageFactory;
    private ICheckoutFactory currentCheckoutFactory;
    private IShareProjectFactory currentShareProjectFactory;
    private IDecorationFilter currentDecorationFilter;
    private IPredefinedPropertySet predefinedPropertySet = new PredefinedPropertySet();
    private ISynchronizeViewActionContributor currentActionContributor;
    private IMailSettingsProvider[] mailSettingsProviders;
    private static ExtensionsManager instance;

    public static synchronized ExtensionsManager getInstance() {
        if (instance == null) {
            instance = new ExtensionsManager();
        }
        return instance;
    }

    public ISynchronizeViewActionContributor getCurrentSynchronizeActionContributor() {
        if (this.currentActionContributor == null) {
            this.currentActionContributor = ExtensionsManager.getDefaultSynchronizeViewActionContributor();
        }
        return this.currentActionContributor;
    }

    public void setCurrentSynchronizeActionContributor(ISynchronizeViewActionContributor contributor) {
        this.currentActionContributor = contributor;
    }

    public IDecorationFilter getCurrentDecorationFilter() {
        if (this.currentDecorationFilter == null) {
            this.currentDecorationFilter = ExtensionsManager.getDefaultDecorationFilter();
        }
        return this.currentDecorationFilter;
    }

    public void setCurrentDecorationFilter(IDecorationFilter filter) {
        this.currentDecorationFilter = filter;
    }

    public ICheckoutFactory getCurrentCheckoutFactory() {
        if (this.currentCheckoutFactory == null) {
            this.currentCheckoutFactory = ExtensionsManager.getDefaultCheckoutFactory();
        }
        return this.currentCheckoutFactory;
    }

    public void setCurrentCheckoutFactory(ICheckoutFactory factory) {
        this.currentCheckoutFactory = factory;
    }

    public IShareProjectFactory getCurrentShareProjectFactory() {
        if (this.currentShareProjectFactory == null) {
            this.currentShareProjectFactory = ExtensionsManager.getDefaultShareProjectFactory();
        }
        return this.currentShareProjectFactory;
    }

    public void setCurrentShareProjectFactory(IShareProjectFactory factory) {
        this.currentShareProjectFactory = factory;
    }

    public IMailSettingsProvider[] getMailSettingsProviders() {
        return this.mailSettingsProviders;
    }

    public ICommitActionFactory getCurrentCommitFactory() {
        if (this.currentCommitFactory == null) {
            this.currentCommitFactory = ExtensionsManager.getDefaultTeamCommitFactory();
        }
        return this.currentCommitFactory;
    }

    public void setCurrentCommitFactory(ICommitActionFactory currentFactory) {
        this.currentCommitFactory = currentFactory;
    }

    public IHistoryViewFactory getCurrentMessageFactory() {
        if (this.currentMessageFactory == null) {
            this.currentMessageFactory = ExtensionsManager.getDefaultCommitMessageFactory();
        }
        return this.currentMessageFactory;
    }

    public void setCurrentMessageFactory(IHistoryViewFactory currentMessageFactory) {
        this.currentMessageFactory = currentMessageFactory;
    }

    public void setPredefinedPropertySet(IPredefinedPropertySet provider) {
        this.predefinedPropertySet = provider;
    }

    public IPredefinedPropertySet getPredefinedPropertySet() {
        return this.predefinedPropertySet;
    }

    public static ICommitActionFactory getDefaultTeamCommitFactory() {
        return new DefaultCommitActionFactory();
    }

    public static IHistoryViewFactory getDefaultCommitMessageFactory() {
        return new DefaultHistoryViewFactory();
    }

    public static ICheckoutFactory getDefaultCheckoutFactory() {
        return new DefaultCheckoutFactory();
    }

    public static IShareProjectFactory getDefaultShareProjectFactory() {
        return new DefaultShareProjectFactory();
    }

    public static IDecorationFilter getDefaultDecorationFilter() {
        return new DefaultDecorationFilter();
    }

    public static ISynchronizeViewActionContributor getDefaultSynchronizeViewActionContributor() {
        return new DefaultSynchronizeViewActionContributor();
    }

    private ExtensionsManager() {
        this.currentDecorationFilter = (IDecorationFilter)this.loadUIExtension("decoration");
        this.currentMessageFactory = (IHistoryViewFactory)this.loadUIExtension("history");
        this.currentCommitFactory = (ICommitActionFactory)this.loadUIExtension("commit");
        this.currentCheckoutFactory = (ICheckoutFactory)this.loadUIExtension("checkout");
        this.currentShareProjectFactory = (IShareProjectFactory)this.loadUIExtension("shareproject");
        this.currentActionContributor = (ISynchronizeViewActionContributor)this.loadUIExtension("synchronizeActionContribution");
        Object[] extensions = this.loadUIExtensions("maildelivery");
        this.mailSettingsProviders = Arrays.asList(extensions).toArray(new IMailSettingsProvider[extensions.length]);
    }

    private Object loadUIExtension(String extensionPoint) {
        Object[] extensions = this.loadUIExtensions(extensionPoint);
        return extensions.length == 0 ? null : extensions[0];
    }

    private Object[] loadUIExtensions(String extensionPoint) {
        return this.loadExtensions(UI_EXTENSION_NAMESPACE, extensionPoint);
    }

    private Object[] loadExtensions(String namespace, String extensionPoint) {
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(namespace, extensionPoint);
        IExtension[] extensions = extension.getExtensions();
        ArrayList<Object> retVal = new ArrayList<Object>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                try {
                    retVal.add(configElements[j].createExecutableExtension("class"));
                }
                catch (CoreException ex) {
                    LoggedOperation.reportError((String)SVNTeamUIPlugin.instance().getResource("Error.LoadUIExtension"), (Throwable)ex);
                }
                ++j;
            }
            ++i;
        }
        return retVal.toArray();
    }
}

