/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.decorator;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.events.IResourceStatesListener;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.decorator.AbstractResourceDecorator;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;

public class FolderDecorator
extends AbstractResourceDecorator {
    protected boolean computeDeep;

    public FolderDecorator(IResourceStatesListener targetListener) {
        super(targetListener);
    }

    protected String getStatus(ILocalResource local) {
        if (this.computeDeep && local.getStatus() == "Normal" && FileUtility.checkForResourcesPresenceRecursive((IResource[])new IResource[]{local.getResource()}, (IStateFilter)IStateFilter.SF_MODIFIED_NOT_IGNORED)) {
            return "Modified";
        }
        return local.getStatus();
    }

    protected void loadConfiguration() {
        super.loadConfiguration();
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        String formatLine = SVNTeamPreferences.getDecorationString(store, "format.folder");
        this.format = this.decorator.parseFormatLine(formatLine);
        this.computeDeep = SVNTeamPreferences.getDecorationBoolean(store, "compute.deep");
    }
}

