/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.crashrecovery;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.polarion.team.svn.core.IConnectedProjectInformation;
import org.polarion.team.svn.core.extension.crashrecovery.ErrorDescription;
import org.polarion.team.svn.core.extension.crashrecovery.IResolutionHelper;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.management.FindRelatedProjectsOperation;
import org.polarion.team.svn.core.operation.local.management.RelocateWorkingCopyOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryRoot;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.crashrecovery.relocated.RelocationChoicesPanel;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class RelocatedProjectHelper
implements IResolutionHelper {
    public boolean acquireResolution(ErrorDescription description) {
        if (description.code == ErrorDescription.PROJECT_IS_RELOCATED_OUTSIDE_PLUGIN) {
            Object[] context = (Object[])description.context;
            final IProject project = (IProject)context[0];
            final RelocationChoicesPanel panel = new RelocationChoicesPanel(project);
            UIMonitorUtility.parallelSyncExec(new Runnable(){

                public void run() {
                    DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                    dialog.open();
                }
            });
            if (panel.getRecoveryAction() == -1) {
                return false;
            }
            final IRepositoryLocation location = (IRepositoryLocation)context[2];
            final String relocatedTo = (String)context[1];
            if (panel.getRecoveryAction() == 0) {
                RelocateWorkingCopyOperation mainOp = new RelocateWorkingCopyOperation(new IResource[]{project}, location);
                CompositeOperation op = new CompositeOperation(mainOp.getId());
                op.add((IActionOperation)mainOp);
                op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)mainOp));
                ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)new NullProgressMonitor());
                return mainOp.getExecutionState() == 0;
            }
            if (panel.getRecoveryAction() == 1) {
                final IRepositoryLocation backup = SVNRemoteStorage.instance().newRepositoryLocation();
                SVNRemoteStorage.instance().copyRepositoryLocation(backup, location);
                FindRelatedProjectsOperation scannerOp = new FindRelatedProjectsOperation(location, new IProject[]{project});
                final RelocateWorkingCopyOperation mainOp = new RelocateWorkingCopyOperation((IResourceProvider)scannerOp, location);
                CompositeOperation op = new CompositeOperation(mainOp.getId());
                op.add((IActionOperation)scannerOp);
                op.add((IActionOperation)new AbstractWorkingCopyOperation("Operation.ChangeRepositoryLocation", new IResource[]{project}){

                    protected void runImpl(IProgressMonitor monitor) throws Exception {
                        location.setUrl(relocatedTo);
                        location.setUrl(location.getRepositoryRootUrl());
                        IConnectedProjectInformation provider = (IConnectedProjectInformation)RepositoryProvider.getProvider((IProject)project, (String)"org.polarion.team.svn.core.svnnature");
                        provider.relocateResource();
                    }
                });
                op.add((IActionOperation)mainOp);
                op.add((IActionOperation)new AbstractWorkingCopyOperation("Operation.CheckRelocationState", new IResource[]{project}){

                    protected void runImpl(IProgressMonitor monitor) throws Exception {
                        if (mainOp.getExecutionState() != 0) {
                            SVNRemoteStorage.instance().copyRepositoryLocation(location, backup);
                            IConnectedProjectInformation provider = (IConnectedProjectInformation)RepositoryProvider.getProvider((IProject)project, (String)"org.polarion.team.svn.core.svnnature");
                            provider.relocateResource();
                        }
                    }
                });
                op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)mainOp));
                ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)new NullProgressMonitor());
                return true;
            }
            if (panel.getRecoveryAction() == 2) {
                try {
                    IConnectedProjectInformation provider = (IConnectedProjectInformation)RepositoryProvider.getProvider((IProject)project, (String)"org.polarion.team.svn.core.svnnature");
                    IRepositoryRoot[] roots = SVNUtility.findRoots((String)relocatedTo, (boolean)true);
                    if (roots != null && roots.length == 1) {
                        provider.switchResource((IRepositoryResource)roots[0].asRepositoryContainer(relocatedTo, false));
                    } else {
                        IRepositoryLocation newLocation = SVNRemoteStorage.instance().newRepositoryLocation();
                        SVNRemoteStorage.instance().copyRepositoryLocation(newLocation, location);
                        newLocation.setUrl(relocatedTo);
                        newLocation.setUrl(newLocation.getRepositoryRootUrl());
                        provider.switchResource((IRepositoryResource)newLocation.asRepositoryContainer(relocatedTo, false));
                    }
                }
                catch (CoreException coreException) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

