/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.crashrecovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.ISVNProgressMonitor;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.extension.CoreExtensionsManager;
import org.polarion.team.svn.core.extension.crashrecovery.ErrorDescription;
import org.polarion.team.svn.core.extension.crashrecovery.IResolutionHelper;
import org.polarion.team.svn.core.extension.factory.ISVNClientWrapperFactory;
import org.polarion.team.svn.core.operation.SVNNullProgressMonitor;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.crashrecovery.invalidmeta.ValidClientsSelectionPanel;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class InvalidMetaHelper
implements IResolutionHelper {
    public boolean acquireResolution(ErrorDescription description) {
        if (description.code == ErrorDescription.CANNOT_READ_PROJECT_METAINFORMATION) {
            String path;
            final IProject project = (IProject)description.context;
            IPath location = project.getLocation();
            if (location == null || !location.append(SVNUtility.getSVNFolderName()).toFile().exists()) {
                return false;
            }
            ISVNClientWrapperFactory current = CoreExtensionsManager.instance().getSVNClientWrapperFactory();
            if (this.isValid(current, path = location.toString())) {
                return true;
            }
            Collection clients = CoreExtensionsManager.instance().getAccessibleClients();
            final ArrayList<ISVNClientWrapperFactory> valid = new ArrayList<ISVNClientWrapperFactory>();
            Iterator it = clients.iterator();
            while (it.hasNext()) {
                ISVNClientWrapperFactory factory = (ISVNClientWrapperFactory)it.next();
                if (!this.isValid(factory, path)) continue;
                valid.add(factory);
            }
            if (valid.size() == 0) {
                return false;
            }
            final boolean[] solved = new boolean[1];
            UIMonitorUtility.parallelSyncExec(new Runnable(){

                public void run() {
                    DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), new ValidClientsSelectionPanel(project, valid));
                    solved[0] = dialog.open() == 0;
                }
            });
            return solved[0];
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isValid(ISVNClientWrapperFactory factory, String path) {
        try {
            boolean bl;
            ISVNClientWrapper proxy = factory.newInstance();
            try {
                Status[] st = proxy.status(path, false, false, true, false, (ISVNProgressMonitor)new SVNNullProgressMonitor());
                bl = st != null && st.length > 0;
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                proxy.dispose();
                throw throwable;
            }
            proxy.dispose();
            return bl;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

