/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.console;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.console.LocalFileHyperlink;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class LocalPathMatcher
implements IPatternMatchListenerDelegate,
IPropertyChangeListener {
    protected Pattern[] patterns = new Pattern[0];
    protected TextConsole console;
    protected boolean enabled;

    public void createPatterns() {
        ArrayList patternList = new ArrayList();
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Status.Added"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Status.Modified"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Status.Deleted"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Status.Missing"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Status.Replaced"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Status.Merged"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Status.Conflicted"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Status.Obstructed"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Action.Added"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Action.Deleted"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Action.Modified"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Action.Replaced"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Action.Reverted"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Action.Restored"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Action.Locked"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Action.Unlocked"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Update.Status.inapplicable"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Update.Status.unknown"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Update.Status.unchanged"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Update.Status.missing"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Update.Status.obstructed"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Update.Status.changed"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Update.Status.merged"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Update.Status.conflicted"));
        this.addPattern(patternList, SVNTeamPlugin.instance().getResource("Console.Update.Status.conflicted_unresolved"));
        this.patterns = patternList.toArray(new Pattern[patternList.size()]);
    }

    protected void addPattern(List patterns, String base) {
        if (base.length() == 0) {
            return;
        }
        String template = ".*\\s+";
        template = String.valueOf(template) + "\\Q" + base + "\\E";
        template = String.valueOf(template) + "\\s+([^\r\n]+)";
        try {
            patterns.add(Pattern.compile(template));
        }
        catch (PatternSyntaxException patternSyntaxException) {}
    }

    public void connect(TextConsole console) {
        this.console = console;
        this.createPatterns();
        this.loadPreferences();
        SVNTeamUIPlugin.instance().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().startsWith("preference.console.")) {
            this.loadPreferences();
        }
    }

    public void disconnect() {
        this.console = null;
        SVNTeamUIPlugin.instance().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void matchFound(PatternMatchEvent event) {
        if (this.console == null || !this.enabled) {
            return;
        }
        UIMonitorUtility.doTaskBusyDefault((IActionOperation)new AddConsoleHyperlinkOperation(event));
    }

    protected void loadPreferences() {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        this.enabled = SVNTeamPreferences.getConsoleBoolean(store, "hyperlinksEnabled");
    }

    protected class AddConsoleHyperlinkOperation
    extends AbstractNonLockingOperation {
        protected PatternMatchEvent event;

        public AddConsoleHyperlinkOperation(PatternMatchEvent event) {
            super("Operation.AddConsoleHyperlink");
            this.event = event;
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            int offset = this.event.getOffset();
            int length = this.event.getLength();
            String path = LocalPathMatcher.this.console.getDocument().get(offset, length);
            if (path == null) {
                return;
            }
            int start = 0;
            int i = 0;
            while (i < LocalPathMatcher.this.patterns.length) {
                Pattern pattern = LocalPathMatcher.this.patterns[i];
                Matcher matcher = pattern.matcher(path);
                while (matcher.find(start)) {
                    length = matcher.end(1) - matcher.start(1);
                    String link = path.substring(matcher.start(1), matcher.end(1));
                    if (link != null) {
                        LocalPathMatcher.this.console.addHyperlink((IHyperlink)new LocalFileHyperlink(link), offset + matcher.start(1), length);
                        return;
                    }
                    start = matcher.end();
                }
                ++i;
            }
        }
    }
}

