/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.composite;

import java.text.MessageFormat;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.resource.IRepositoryContainer;
import org.polarion.team.svn.core.resource.IRepositoryFile;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.composite.RevisionComposite;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.panel.common.RepositoryTreePanel;
import org.polarion.team.svn.ui.utility.UserInputHistory;
import org.polarion.team.svn.ui.verifier.AbsolutePathVerifier;
import org.polarion.team.svn.ui.verifier.AbstractVerifier;
import org.polarion.team.svn.ui.verifier.CompositeVerifier;
import org.polarion.team.svn.ui.verifier.IValidationManager;
import org.polarion.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.polarion.team.svn.ui.verifier.URLVerifier;

public class RepositoryResourceSelectionComposite
extends Composite {
    public static final int MODE_DEFAULT = 0;
    public static final int MODE_TWO = 1;
    public static final int MODE_AUTO = 2;
    protected Combo urlText;
    protected Button browse;
    protected UserInputHistory urlHistory;
    protected RevisionComposite revisionComposite;
    protected RevisionComposite secondRevisionComposite;
    protected IValidationManager validationManager;
    protected IRepositoryResource baseResource;
    protected boolean stopOnCopy;
    protected int twoRevisions;
    protected IRepositoryResource selectedResource;
    protected IRepositoryResource secondSelectedResource;
    protected CompositeVerifier verifier;
    protected String selectionTitle;
    protected String selectionDescription;
    protected String comboId;

    public RepositoryResourceSelectionComposite(Composite parent, int style, IValidationManager validationManager, String historyKey, IRepositoryResource baseResource, boolean stopOnCopy, String selectionTitle, String selectionDescription, int twoRevisions) {
        this(parent, style, validationManager, historyKey, "RepositoryResourceSelectionComposite.URL", baseResource, stopOnCopy, selectionTitle, selectionDescription, twoRevisions);
    }

    public RepositoryResourceSelectionComposite(Composite parent, int style, IValidationManager validationManager, String historyKey, String comboId, IRepositoryResource baseResource, boolean stopOnCopy, String selectionTitle, String selectionDescription, int twoRevisions) {
        super(parent, style);
        this.stopOnCopy = stopOnCopy;
        this.urlHistory = new UserInputHistory(historyKey);
        this.validationManager = validationManager;
        this.baseResource = baseResource;
        this.selectedResource = this.getDestination(this.baseResource.getUrl());
        this.secondSelectedResource = this.getDestination(this.baseResource.getUrl());
        this.selectionTitle = selectionTitle;
        this.selectionDescription = selectionDescription;
        this.twoRevisions = twoRevisions;
        this.comboId = comboId;
        this.createControls();
    }

    public IRepositoryResource getSelectedResource() {
        this.selectedResource.setSelectedRevision(this.revisionComposite.getSelectedRevision());
        this.selectedResource.setPegRevision(this.baseResource.getPegRevision());
        return this.selectedResource;
    }

    public void setSelectedResource(IRepositoryResource resource, Revision secondRevision) {
        this.selectedResource = resource;
        this.revisionComposite.setSelectedResource(SVNUtility.copyOf((IRepositoryResource)this.selectedResource));
        if (this.secondRevisionComposite != null) {
            this.secondSelectedResource = SVNUtility.copyOf((IRepositoryResource)resource);
            this.secondSelectedResource.setSelectedRevision(secondRevision != null ? secondRevision : Revision.HEAD);
            this.secondRevisionComposite.setSelectedResource(this.secondSelectedResource);
        }
        this.setUrl(this.selectedResource.getUrl());
    }

    public Revision getStartRevision() {
        return this.revisionComposite.getSelectedRevision();
    }

    public Revision getSecondSelectedRevision() {
        if (this.secondSelectedResource == null || this.secondRevisionComposite == null) {
            return null;
        }
        return this.secondRevisionComposite.getSelectedRevision();
    }

    public void setCurrentRevision(long currentRevision) {
        this.revisionComposite.setCurrentRevision(currentRevision);
    }

    public void addVerifier(AbstractVerifier verifier) {
        this.verifier.add(verifier);
    }

    public void removeVerifier(AbstractVerifier verifier) {
        this.verifier.remove(verifier);
    }

    public void setUrl(String url) {
        this.urlText.setText(url);
    }

    public String getUrl() {
        return this.urlText.getText();
    }

    public void saveHistory() {
        this.urlHistory.addLine(this.urlText.getText());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.urlText.setEnabled(enabled);
        this.browse.setEnabled(enabled);
        this.revisionComposite.setEnabled(enabled);
        if (this.secondRevisionComposite != null) {
            this.secondRevisionComposite.setEnabled(enabled);
        }
    }

    private void createControls() {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        Label urlLabel = new Label((Composite)this, 0);
        urlLabel.setLayoutData((Object)new GridData());
        urlLabel.setText(SVNTeamUIPlugin.instance().getResource(this.comboId));
        Composite select = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        select.setLayout((Layout)layout);
        data = new GridData(768);
        select.setLayoutData((Object)data);
        this.urlText = new Combo(select, 0);
        data = new GridData(768);
        data.widthHint = 200;
        this.urlText.setLayoutData((Object)data);
        this.urlText.setVisibleItemCount(this.urlHistory.getDepth());
        this.urlText.setItems(this.urlHistory.getHistory());
        this.urlText.setText(this.selectedResource.getUrl());
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositoryResourceSelectionComposite.this.checkUrl();
                RepositoryResourceSelectionComposite.this.revisionComposite.setSelectedResource(RepositoryResourceSelectionComposite.this.selectedResource);
                if (RepositoryResourceSelectionComposite.this.secondRevisionComposite != null) {
                    RepositoryResourceSelectionComposite.this.secondRevisionComposite.setSelectedResource(RepositoryResourceSelectionComposite.this.secondSelectedResource);
                }
            }
        });
        this.verifier = new CompositeVerifier();
        this.verifier.add(new NonEmptyFieldVerifier(SVNTeamUIPlugin.instance().getResource(String.valueOf(this.comboId) + ".Verifier")));
        this.verifier.add(new URLVerifier(SVNTeamUIPlugin.instance().getResource(String.valueOf(this.comboId) + ".Verifier")){

            protected String getErrorMessage(Control input) {
                String url;
                String error = super.getErrorMessage(input);
                if (error == null && RepositoryResourceSelectionComposite.this.getDestination(url = this.getText(input)) == null) {
                    error = MessageFormat.format(SVNTeamUIPlugin.instance().getResource("RepositoryResourceSelectionComposite.URL.Verifier.Error"), url, RepositoryResourceSelectionComposite.this.selectedResource.getRepositoryLocation().getUrl());
                }
                return error;
            }
        });
        this.verifier.add(new AbsolutePathVerifier(this.comboId));
        this.validationManager.attachTo((Control)this.urlText, this.verifier);
        this.browse = new Button(select, 8);
        this.browse.setText(SVNTeamUIPlugin.instance().getResource("Button.Browse"));
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(this.browse);
        this.browse.setLayoutData((Object)data);
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryTreePanel panel = new RepositoryTreePanel(SVNTeamUIPlugin.instance().getResource("RepositoryResourceSelectionComposite.Select.Title"), RepositoryResourceSelectionComposite.this.selectionTitle, RepositoryResourceSelectionComposite.this.selectionDescription, new IRepositoryResource[]{RepositoryResourceSelectionComposite.this.baseResource}, true);
                panel.setAllowFiles(RepositoryResourceSelectionComposite.this.baseResource instanceof IRepositoryFile);
                DefaultDialog browser = new DefaultDialog(RepositoryResourceSelectionComposite.this.getShell(), panel);
                if (browser.open() == 0) {
                    RepositoryResourceSelectionComposite.this.selectedResource = panel.getSelectedResource();
                    RepositoryResourceSelectionComposite.this.urlText.setText(RepositoryResourceSelectionComposite.this.selectedResource.getUrl());
                    RepositoryResourceSelectionComposite.this.revisionComposite.setSelectedResource(RepositoryResourceSelectionComposite.this.selectedResource);
                    if (RepositoryResourceSelectionComposite.this.secondRevisionComposite != null) {
                        RepositoryResourceSelectionComposite.this.secondSelectedResource = panel.getSelectedResource();
                        RepositoryResourceSelectionComposite.this.secondRevisionComposite.setSelectedResource(RepositoryResourceSelectionComposite.this.secondSelectedResource);
                    }
                    RepositoryResourceSelectionComposite.this.checkUrl();
                    RepositoryResourceSelectionComposite.this.validationManager.validateContent();
                }
            }
        });
        Composite revisions = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        revisions.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        revisions.setLayoutData((Object)data);
        this.revisionComposite = new RevisionComposite(revisions, this.validationManager, this.stopOnCopy, new String[]{(this.twoRevisions & 1) != 0 ? SVNTeamUIPlugin.instance().getResource("RepositoryResourceSelectionComposite.StartRevision") : SVNTeamUIPlugin.instance().getResource("RepositoryResourceSelectionComposite.Revision"), (this.twoRevisions & 2) != 0 ? SVNTeamUIPlugin.instance().getResource("RepositoryResourceSelectionComposite.Autodetect") : SVNTeamUIPlugin.instance().getResource("RepositoryResourceSelectionComposite.HeadRevision")}, (this.twoRevisions & 2) != 0 ? null : Revision.HEAD){

            public void additionalValidation() {
                RepositoryResourceSelectionComposite.this.validateRevisions();
            }
        };
        data = new GridData(768);
        data.horizontalSpan = (this.twoRevisions & 1) != 0 ? 1 : 2;
        this.revisionComposite.setLayoutData(data);
        this.revisionComposite.setSelectedResource(this.selectedResource);
        if ((this.twoRevisions & 1) != 0) {
            this.secondRevisionComposite = new RevisionComposite(revisions, this.validationManager, this.stopOnCopy, new String[]{SVNTeamUIPlugin.instance().getResource("RepositoryResourceSelectionComposite.StopRevision"), SVNTeamUIPlugin.instance().getResource("RepositoryResourceSelectionComposite.HeadRevision")}, Revision.HEAD){

                public void additionalValidation() {
                    RepositoryResourceSelectionComposite.this.validateRevisions();
                }
            };
            data = new GridData(768);
            this.secondRevisionComposite.setLayoutData(data);
            this.secondRevisionComposite.setSelectedResource(this.secondSelectedResource);
        }
    }

    protected void checkUrl() {
        String url = this.urlText.getText().trim();
        IRepositoryResource tmp = this.getDestination(url);
        if (tmp != null) {
            tmp.setSelectedRevision(this.selectedResource.getSelectedRevision());
            this.selectedResource = tmp;
            tmp = this.getDestination(url);
            tmp.setSelectedRevision(this.secondSelectedResource.getSelectedRevision());
            this.secondSelectedResource = tmp;
            this.revisionComposite.setEnabled(true);
            if (this.secondRevisionComposite != null) {
                this.secondRevisionComposite.setEnabled(true);
            }
        } else {
            this.revisionComposite.setEnabled(false);
            if (this.secondRevisionComposite != null) {
                this.secondRevisionComposite.setEnabled(false);
            }
        }
    }

    protected IRepositoryResource getDestination(String url) {
        IRepositoryLocation location = this.baseResource.getRepositoryLocation();
        url = SVNUtility.normalizeURL((String)url);
        try {
            return this.baseResource instanceof IRepositoryContainer ? location.asRepositoryContainer(url, true) : location.asRepositoryFile(url, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    protected void validateRevisions() {
        if ((this.twoRevisions & 1) != 0) {
            this.validationManager.validateContent();
        }
    }
}

