/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.composite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.compare.internal.TabFolderLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.polarion.team.svn.core.extension.CoreExtensionsManager;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.ProxySettings;
import org.polarion.team.svn.core.resource.SSHSettings;
import org.polarion.team.svn.core.resource.SSLSettings;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.composite.AbstractDynamicComposite;
import org.polarion.team.svn.ui.composite.IPropertiesPanel;
import org.polarion.team.svn.ui.composite.ISecurityInfoProvider;
import org.polarion.team.svn.ui.composite.ProxyComposite;
import org.polarion.team.svn.ui.composite.RepositoryPropertiesComposite;
import org.polarion.team.svn.ui.composite.RepositoryRootsComposite;
import org.polarion.team.svn.ui.composite.SSHComposite;
import org.polarion.team.svn.ui.composite.SSLComposite;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.verifier.AbstractVerifier;
import org.polarion.team.svn.ui.verifier.IValidationManager;

public class RepositoryPropertiesTabFolder
extends Composite
implements IPropertiesPanel,
ISecurityInfoProvider {
    protected RepositoryPropertiesComposite repositoryPropertiesPanel;
    protected SSHComposite sshComposite;
    protected SSLComposite sslComposite;
    protected ProxyComposite proxyComposite;
    protected RepositoryRootsComposite rootsComposite;
    protected Composite parent;
    protected IRepositoryLocation repositoryLocation;
    protected int style;
    protected IValidationManager validationManager;
    protected Button validateButton;
    protected Button resetChangesButton;
    protected boolean validateOnFinish;
    protected boolean forceDisableRoots;
    protected boolean createNew;
    protected Combo cachedRealms;
    protected TabItem sshTab;
    protected TabItem sslTab;
    protected TabItem proxyTab;
    protected Composite unavailableSSHComposite;
    protected Composite unavailableProxyComposite;
    protected IRepositoryLocation backup;
    protected String sipUsername;
    protected String sipPassword;
    protected boolean sipIsPasswordSaved;
    protected ProxySettings sipProxySettings;
    protected SSHSettings sipSSHSettings;
    protected SSLSettings sipSSLSettings;

    public RepositoryPropertiesTabFolder(Composite parent, int style, IValidationManager validationManager, IRepositoryLocation repositoryLocation) {
        super(parent, style);
        this.parent = parent;
        this.style = style;
        this.validationManager = validationManager;
        this.repositoryLocation = repositoryLocation;
        boolean bl = this.createNew = repositoryLocation == null;
        if (this.createNew) {
            this.repositoryLocation = SVNRemoteStorage.instance().newRepositoryLocation();
        } else {
            this.backup = SVNRemoteStorage.instance().newRepositoryLocation();
            SVNRemoteStorage.instance().copyRepositoryLocation(this.backup, this.repositoryLocation);
        }
    }

    public String getUsername() {
        this.sipUsername = this.repositoryPropertiesPanel.getUsernameDirect();
        return this.sipUsername;
    }

    public void setUsername(String username) {
        this.sipUsername = username;
    }

    public String getPassword() {
        this.sipPassword = this.repositoryPropertiesPanel.getPasswordDirect();
        return this.sipPassword;
    }

    public void setPassword(String password) {
        this.sipPassword = password;
    }

    public boolean isPasswordSaved() {
        this.sipIsPasswordSaved = this.repositoryPropertiesPanel.getPasswordSavedDirect();
        return this.sipIsPasswordSaved;
    }

    public void setPasswordSaved(boolean saved) {
        this.sipIsPasswordSaved = saved;
    }

    public ProxySettings getProxySettings() {
        this.sipProxySettings = this.proxyComposite.getProxySettingsDirect();
        return this.sipProxySettings;
    }

    public SSLSettings getSSLSettings() {
        this.sipSSLSettings = this.sslComposite.getSSLSettingsDirect();
        return this.sipSSLSettings;
    }

    public SSHSettings getSSHSettings() {
        this.sipSSHSettings = this.sshComposite.getSSHSettingsDirect();
        return this.sipSSHSettings;
    }

    public void commit() {
        this.repositoryPropertiesPanel.setUsernameDirect(this.sipUsername);
        this.repositoryPropertiesPanel.setPasswordDirect(this.sipPassword);
        this.repositoryPropertiesPanel.setPasswordSavedDirect(this.sipIsPasswordSaved);
        this.sshComposite.setSSHSettingsDirect(this.sipSSHSettings);
        this.sslComposite.setSSLSettingsDirect(this.sipSSLSettings);
        this.proxyComposite.setProxySettingsDirect(this.sipProxySettings);
    }

    public void initialize() {
        int widthHint;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 7;
        this.setLayout((Layout)layout);
        TabFolder tabFolder = new TabFolder((Composite)this, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout());
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.General"));
        tabItem.setControl((Control)this.createRepositoryPropertiesPanel((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.Advanced"));
        tabItem.setControl((Control)this.createRepositoryRootsComposite((Composite)tabFolder));
        this.unavailableSSHComposite = this.createUnavailableComposite((Composite)tabFolder);
        this.unavailableSSHComposite.setVisible(false);
        this.createSSHHostComposite((Composite)tabFolder);
        this.sshComposite.setVisible(false);
        this.sshTab = new TabItem(tabFolder, 0);
        this.sshTab.setText(SVNTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.SSHSettings"));
        if (CoreExtensionsManager.instance().getSVNClientWrapperFactory().isSSHOptionsAllowed()) {
            this.sshTab.setControl((Control)this.sshComposite);
        } else {
            this.sshTab.setControl((Control)this.unavailableSSHComposite);
        }
        this.createSSLHostComposite((Composite)tabFolder);
        this.sslComposite.setVisible(false);
        this.sslTab = new TabItem(tabFolder, 0);
        this.sslTab.setText(SVNTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.SSLSettings"));
        this.sslTab.setControl((Control)this.sslComposite);
        this.unavailableProxyComposite = this.createUnavailableComposite((Composite)tabFolder);
        this.unavailableProxyComposite.setVisible(false);
        this.createProxyComposite((Composite)tabFolder);
        this.proxyComposite.setVisible(false);
        this.proxyTab = new TabItem(tabFolder, 0);
        this.proxyTab.setText(SVNTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.Proxy"));
        if (CoreExtensionsManager.instance().getSVNClientWrapperFactory().isProxyOptionsAllowed()) {
            this.proxyTab.setControl((Control)this.proxyComposite);
        } else {
            this.proxyTab.setControl((Control)this.unavailableProxyComposite);
        }
        GridData data = null;
        Composite bottomPart = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        bottomPart.setLayout((Layout)layout);
        data = new GridData(768);
        bottomPart.setLayoutData((Object)data);
        Composite realmsComposite = new Composite(bottomPart, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        realmsComposite.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 3;
        realmsComposite.setLayoutData((Object)data);
        Label label = new Label(realmsComposite, 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        label.setText(SVNTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.ShowFor"));
        this.cachedRealms = new Combo(realmsComposite, 2056);
        final Button deleteRealm = new Button(realmsComposite, 8);
        data = new GridData(768);
        this.cachedRealms.setLayoutData((Object)data);
        final ArrayList<String> itemSet = new ArrayList<String>();
        itemSet.add("<Repository Location>");
        itemSet.addAll(this.repositoryLocation.getRealms());
        this.cachedRealms.setItems(itemSet.toArray(new String[itemSet.size()]));
        this.cachedRealms.select(0);
        this.cachedRealms.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                deleteRealm.setEnabled(RepositoryPropertiesTabFolder.this.cachedRealms.getSelectionIndex() != 0);
                RepositoryPropertiesTabFolder.this.realmSelectionChanged();
            }
        });
        ImageDescriptor imgDescr = SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/delete_realm.gif");
        deleteRealm.setImage(imgDescr.createImage());
        data = new GridData();
        data.heightHint = this.cachedRealms.getTextHeight() + 2;
        deleteRealm.setLayoutData((Object)data);
        deleteRealm.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = RepositoryPropertiesTabFolder.this.cachedRealms.getSelectionIndex();
                if (idx != 0) {
                    String item = RepositoryPropertiesTabFolder.this.cachedRealms.getItem(idx);
                    itemSet.remove(item);
                    RepositoryPropertiesTabFolder.this.cachedRealms.setItems(itemSet.toArray(new String[itemSet.size()]));
                    RepositoryPropertiesTabFolder.this.cachedRealms.select(idx - 1);
                    RepositoryPropertiesTabFolder.this.realmSelectionChanged();
                }
                boolean enabled = RepositoryPropertiesTabFolder.this.cachedRealms.getItems().length > 1;
                ((Button)e.widget).setEnabled(enabled);
                RepositoryPropertiesTabFolder.this.cachedRealms.setEnabled(enabled);
                idx = RepositoryPropertiesTabFolder.this.cachedRealms.getSelectionIndex();
                if (idx == 0) {
                    ((Button)e.widget).setEnabled(false);
                }
            }
        });
        deleteRealm.setEnabled(false);
        this.cachedRealms.setEnabled(itemSet.size() > 1);
        this.validateButton = new Button(bottomPart, 32);
        data = new GridData(32);
        this.validateButton.setLayoutData((Object)data);
        this.validateButton.setText(SVNTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.ValidateOnFinish"));
        this.validateButton.setSelection(true);
        Text empty = new Text(bottomPart, 8);
        data = new GridData(768);
        empty.setLayoutData((Object)data);
        empty.setVisible(false);
        this.resetChangesButton = new Button(bottomPart, 8);
        data = new GridData(128);
        this.resetChangesButton.setText(SVNTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.ResetChanges"));
        data.widthHint = widthHint = DefaultDialog.computeButtonWidth(this.resetChangesButton);
        this.resetChangesButton.setLayoutData((Object)data);
        this.resetChangesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryPropertiesTabFolder.this.resetChanges();
                RepositoryPropertiesTabFolder.this.validationManager.validateContent();
            }
        });
        if ((this.repositoryLocation.getUsername() == null || this.repositoryLocation.getUsername().length() == 0) && this.repositoryLocation.getRealms().size() > 0) {
            this.cachedRealms.select(1);
            deleteRealm.setEnabled(true);
            this.realmSelectionChanged();
        }
    }

    protected void realmSelectionChanged() {
        IRepositoryLocation location = this.repositoryLocation;
        int idx = this.cachedRealms.getSelectionIndex();
        if (idx != 0) {
            location = location.getLocationForRealm(this.cachedRealms.getItem(idx));
        }
        this.repositoryPropertiesPanel.saveChanges();
        this.repositoryPropertiesPanel.setCredentialsInput(location, this);
        this.repositoryPropertiesPanel.resetChanges();
        if (CoreExtensionsManager.instance().getSVNClientWrapperFactory().isSSHOptionsAllowed()) {
            this.sshComposite.saveChanges();
            this.sshComposite.setCredentialsInput(location.getSSHSettings());
            this.sshComposite.resetChanges();
        }
        this.sslComposite.saveChanges();
        this.sslComposite.setCredentialsInput(location.getSSLSettings());
        this.sslComposite.resetChanges();
    }

    protected Composite createRepositoryPropertiesPanel(Composite tabFolder) {
        this.repositoryPropertiesPanel = new RepositoryPropertiesComposite(tabFolder, this.style, this.validationManager);
        this.repositoryPropertiesPanel.setRepositoryLocation(this.repositoryLocation, this.createNew ? null : this.repositoryLocation.getRepositoryRootUrl(), this);
        this.repositoryPropertiesPanel.initialize();
        return this.repositoryPropertiesPanel;
    }

    protected Composite createSSHHostComposite(Composite tabFolder) {
        this.sshComposite = new SSHComposite(tabFolder, this.style, this.validationManager);
        this.sshComposite.setCredentialsInput(this.repositoryLocation.getSSHSettings());
        this.sshComposite.initialize();
        return this.sshComposite;
    }

    protected Composite createProxyComposite(Composite tabFolder) {
        this.proxyComposite = new ProxyComposite(tabFolder, this.style, this.validationManager);
        ProxySettings settings = this.repositoryLocation.getProxySettings();
        this.proxyComposite.setProxyEnabled(settings.isEnabled());
        this.proxyComposite.setHost(settings.getHost());
        this.proxyComposite.setPort(settings.getPort());
        this.proxyComposite.setAuthenticationEnabled(settings.isAuthenticationEnabled());
        this.proxyComposite.setUsername(settings.getUsername());
        this.proxyComposite.setPassword(settings.getPassword());
        this.proxyComposite.setSavePassword(settings.isPasswordSaved());
        this.proxyComposite.initialize();
        return this.proxyComposite;
    }

    protected Composite createSSLHostComposite(Composite tabFolder) {
        this.sslComposite = new SSLComposite(tabFolder, this.style, this.validationManager);
        this.sslComposite.setCredentialsInput(this.repositoryLocation.getSSLSettings());
        this.sslComposite.initialize();
        return this.sslComposite;
    }

    protected Composite createRepositoryRootsComposite(Composite tabFolder) {
        this.rootsComposite = new RepositoryRootsComposite(tabFolder, this.style, this.validationManager);
        this.rootsComposite.setStructureEnabled(this.repositoryLocation.isStructureEnabled());
        this.rootsComposite.setTrunkLocation(this.repositoryLocation.getUserInputTrunk());
        this.rootsComposite.setBranchesLocation(this.repositoryLocation.getUserInputBranches());
        this.rootsComposite.setTagsLocation(this.repositoryLocation.getUserInputTags());
        this.rootsComposite.setCreateLocation(this.createNew);
        this.rootsComposite.initialize();
        return this.rootsComposite;
    }

    protected Composite createUnavailableComposite(Composite tabFolder) {
        Composite composite = new Composite(tabFolder, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 64);
        label.setText(SVNTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.UnavailableMessage"));
        Link link = new Link(composite, 0);
        link.setText(SVNTeamUIPlugin.instance().getResource("RepositoryPropertiesTabFolder.LinkToPreferences"));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryPropertiesTabFolder.this.handleLinkSelection();
            }
        });
        return composite;
    }

    public void handleLinkSelection() {
        boolean sshWasAllowed = CoreExtensionsManager.instance().getSVNClientWrapperFactory().isSSHOptionsAllowed();
        boolean proxyWasAllowed = CoreExtensionsManager.instance().getSVNClientWrapperFactory().isProxyOptionsAllowed();
        String pageId = "org.polarion.team.svn.ui.SVNTeamPreferences";
        PreferencesUtil.createPreferenceDialogOn(null, (String)pageId, (String[])new String[]{pageId}, null).open();
        boolean sshAllowed = CoreExtensionsManager.instance().getSVNClientWrapperFactory().isSSHOptionsAllowed();
        boolean proxyAllowed = CoreExtensionsManager.instance().getSVNClientWrapperFactory().isProxyOptionsAllowed();
        this.updateTabContent(sshWasAllowed, sshAllowed, this.sshTab, this.sshComposite, this.unavailableSSHComposite);
        this.updateTabContent(proxyWasAllowed, proxyAllowed, this.proxyTab, this.proxyComposite, this.unavailableProxyComposite);
    }

    public void updateTabContent(boolean wasAvailable, boolean isAvailable, TabItem tab, AbstractDynamicComposite availableComposite, Composite unavailableComposite) {
        if (isAvailable) {
            if (!wasAvailable) {
                availableComposite.restoreAppearance();
                tab.setControl((Control)availableComposite);
            }
        } else if (wasAvailable) {
            availableComposite.saveAppearance();
            tab.setControl((Control)unavailableComposite);
            availableComposite.revalidateContent();
        }
    }

    public IRepositoryLocation getRepositoryLocation() {
        return this.repositoryLocation;
    }

    public String getLocationUrl() {
        return this.repositoryPropertiesPanel.getLocationUrl();
    }

    public boolean isStructureEnabled() {
        return this.rootsComposite.isStructureEnabled();
    }

    public boolean isValidateOnFinishRequested() {
        return this.validateOnFinish;
    }

    public void saveChanges() {
        this.repositoryPropertiesPanel.saveChanges();
        if (CoreExtensionsManager.instance().getSVNClientWrapperFactory().isSSHOptionsAllowed()) {
            this.sshComposite.saveChanges();
        }
        this.sslComposite.saveChanges();
        if (CoreExtensionsManager.instance().getSVNClientWrapperFactory().isProxyOptionsAllowed()) {
            this.proxyComposite.saveChanges();
        }
        this.rootsComposite.saveChanges();
        if (CoreExtensionsManager.instance().getSVNClientWrapperFactory().isProxyOptionsAllowed()) {
            ProxySettings proxySettings = this.repositoryLocation.getProxySettings();
            proxySettings.setEnabled(this.proxyComposite.isProxyEnabled());
            proxySettings.setAuthenticationEnabled(this.proxyComposite.isAuthenticationEnabled());
            proxySettings.setHost(this.proxyComposite.getHost());
            proxySettings.setPort(this.proxyComposite.getPort());
            proxySettings.setUsername(this.proxyComposite.getUsername());
            proxySettings.setPassword(this.proxyComposite.getPassword());
            proxySettings.setPasswordSaved(this.proxyComposite.isSavePassword());
        }
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        boolean enabled = this.rootsComposite.isStructureEnabled();
        if (enabled) {
            this.repositoryLocation.setTrunkLocation(this.rootsComposite.getTrunkLocation());
            this.repositoryLocation.setBranchesLocation(this.rootsComposite.getBranchesLocation());
            this.repositoryLocation.setTagsLocation(this.rootsComposite.getTagsLocation());
        } else if (this.createNew) {
            this.repositoryLocation.setTrunkLocation(SVNTeamPreferences.getRepositoryString(store, "head"));
            this.repositoryLocation.setBranchesLocation(SVNTeamPreferences.getRepositoryString(store, "branches"));
            this.repositoryLocation.setTagsLocation(SVNTeamPreferences.getRepositoryString(store, "tags"));
        }
        this.repositoryLocation.setStructureEnabled(enabled);
        HashSet<String> realms = new HashSet<String>(Arrays.asList(this.cachedRealms.getItems()));
        Iterator it = this.repositoryLocation.getRealms().iterator();
        while (it.hasNext()) {
            if (realms.contains(it.next())) continue;
            it.remove();
        }
        this.validateOnFinish = this.validateButton.getSelection();
    }

    public void resetChanges() {
        this.repositoryPropertiesPanel.resetChanges();
        if (CoreExtensionsManager.instance().getSVNClientWrapperFactory().isSSHOptionsAllowed()) {
            this.sshComposite.resetChanges();
        }
        this.sslComposite.resetChanges();
        if (CoreExtensionsManager.instance().getSVNClientWrapperFactory().isProxyOptionsAllowed()) {
            this.proxyComposite.resetChanges();
        }
        this.rootsComposite.resetChanges();
    }

    public void cancelChanges() {
        if (!this.createNew) {
            SVNRemoteStorage.instance().copyRepositoryLocation(this.repositoryLocation, this.backup);
        }
    }

    public void setForceDisableRoots(boolean forceDisableRoots, AbstractVerifier verifier) {
        if (this.rootsComposite != null) {
            this.rootsComposite.setForceDisableRoots(forceDisableRoots);
        }
        if (this.repositoryPropertiesPanel != null) {
            this.repositoryPropertiesPanel.defineUrlVerifier(verifier);
        }
    }
}

