/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.composite;

import java.io.FileOutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.IResourcePropertyProvider;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.property.RemovePropertiesOperation;
import org.polarion.team.svn.core.operation.remote.GetRemotePropertiesOperation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.action.local.SetKeywordsAction;
import org.polarion.team.svn.ui.action.local.SetPropertyAction;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.dialog.SetPropertyWithOverrideDialog;
import org.polarion.team.svn.ui.panel.view.property.PropertyApplyPanel;
import org.polarion.team.svn.ui.panel.view.property.PropertyEditPanel;
import org.polarion.team.svn.ui.properties.RemovePropertyDialog;
import org.polarion.team.svn.ui.utility.TableViewerSorter;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class PropertiesComposite
extends Composite {
    public static final int APPLY_TO_ALL = 0;
    public static final int APPLY_TO_FILES = 1;
    public static final int APPLY_TO_FOLDERS = 2;
    protected PropertyData[] properties;
    protected TableViewer propertyViewer;
    protected Text propertyText;
    protected IResourcePropertyProvider provider;
    protected IResource wcResource;
    protected IRepositoryResource repositoryResource;
    protected IAdaptable resource;
    protected ViewPart workbenchPart;

    public PropertiesComposite(Composite parent, ViewPart workbenchPart) {
        super(parent, 0);
        this.workbenchPart = workbenchPart;
        this.createControls(parent);
    }

    public PropertiesComposite(Composite parent) {
        this(parent, null);
    }

    public synchronized void setResource(IAdaptable resource, IResourcePropertyProvider provider) {
        if (resource instanceof IResource) {
            this.repositoryResource = null;
            this.wcResource = (IResource)resource;
        } else if (resource instanceof IRepositoryResource) {
            this.repositoryResource = (IRepositoryResource)resource;
        }
        this.provider = provider;
    }

    public IActionOperation getRefreshViewOperation() {
        return new AbstractNonLockingOperation("Operation.PShowProperties"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runImpl(IProgressMonitor monitor) throws Exception {
                PropertiesComposite propertiesComposite = PropertiesComposite.this;
                synchronized (propertiesComposite) {
                    if (PropertiesComposite.this.provider != null && PropertiesComposite.this.provider.getExecutionState() == 0) {
                        if (PropertiesComposite.this.resource != null && !PropertiesComposite.this.resource.equals(PropertiesComposite.this.provider.getLocal()) && !PropertiesComposite.this.resource.equals(PropertiesComposite.this.provider.getRemote())) {
                            return;
                        }
                        PropertiesComposite.this.provider.refresh();
                        PropertiesComposite.this.properties = PropertiesComposite.this.provider.getProperties();
                        if (PropertiesComposite.this.properties == null) {
                            PropertiesComposite.this.properties = new PropertyData[0];
                        }
                    } else {
                        PropertiesComposite.this.properties = null;
                    }
                }
                if (!PropertiesComposite.this.isDisposed()) {
                    PropertiesComposite.this.getDisplay().syncExec(new Runnable(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            1.access$0(this.this$1).initializeComposite();
                        }
                    });
                }
            }

            static /* synthetic */ PropertiesComposite access$0(1 var0) {
                return var0.PropertiesComposite.this;
            }
        };
    }

    private void createControls(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        SashForm innerSashForm = new SashForm((Composite)this, 512);
        data = new GridData(1808);
        innerSashForm.setLayoutData((Object)data);
        Table table = new Table((Composite)innerSashForm, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        table.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        this.propertyText = new Text((Composite)innerSashForm, 770);
        this.propertyText.setEditable(false);
        this.propertyText.setBackground(this.propertyText.getBackground());
        data = new GridData(1808);
        this.propertyText.setLayoutData((Object)data);
        innerSashForm.setWeights(new int[]{70, 30});
        this.propertyViewer = new TableViewer(table);
        TableViewerSorter sorter = new TableViewerSorter(this.propertyViewer, new TableViewerSorter.IColumnComparator(){

            public int compare(Object row1, Object row2, int column) {
                if (row1 instanceof PropertyData) {
                    PropertyData data1 = (PropertyData)row1;
                    PropertyData data2 = (PropertyData)row2;
                    return column == 0 ? TableViewerSorter.compare(data1.name, data2.name) : TableViewerSorter.compare(data1.value, data2.value);
                }
                return 0;
            }
        });
        this.propertyViewer.setSorter((ViewerSorter)sorter);
        this.propertyViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection;
                if (event.getSelection() instanceof IStructuredSelection && (selection = ((IStructuredSelection)event.getSelection()).getFirstElement()) != null && selection instanceof PropertyData) {
                    PropertiesComposite.this.propertyText.setText(((PropertyData)selection).value);
                }
            }
        });
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(SVNTeamUIPlugin.instance().getResource("PropertiesComposite.Name"));
        col.addSelectionListener((SelectionListener)sorter);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(SVNTeamUIPlugin.instance().getResource("PropertiesComposite.Value"));
        col.addSelectionListener((SelectionListener)sorter);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, true));
        sorter.setDefaultColumn(0);
        this.propertyViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (PropertiesComposite.this.wcResource == null && PropertiesComposite.this.repositoryResource == null) {
                    return new PropertyData[0];
                }
                return PropertiesComposite.this.properties;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.propertyViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                PropertyData data = (PropertyData)element;
                if (columnIndex == 0) {
                    return data.name;
                }
                String value = data.value;
                return FileUtility.formatMultilineText((String)value);
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)table);
        menuMgr.addMenuListener(new IMenuListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void menuAboutToShow(IMenuManager manager) {
                PropertiesComposite propertiesComposite = PropertiesComposite.this;
                synchronized (propertiesComposite) {
                    boolean isEditAllowed;
                    manager.add((IContributionItem)new Separator("additions"));
                    IStructuredSelection tSelection = (IStructuredSelection)PropertiesComposite.this.propertyViewer.getSelection();
                    Action tAction = null;
                    boolean bl = isEditAllowed = PropertiesComposite.this.provider != null && PropertiesComposite.this.provider.isEditAllowed();
                    if (PropertiesComposite.this.wcResource != null && PropertiesComposite.this.repositoryResource == null) {
                        tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("PropertiesComposite.Add")){
                            final /* synthetic */ 7 this$1;
                            {
                                this.this$1 = var1_1;
                                super($anonymous0);
                            }

                            public void run() {
                                7.access$0(this.this$1).editProperty(null);
                            }
                        };
                        manager.add((IAction)tAction);
                        tAction.setEnabled(isEditAllowed);
                        tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("PropertiesComposite.Edit"), tSelection){
                            final /* synthetic */ 7 this$1;
                            private final /* synthetic */ IStructuredSelection val$tSelection;
                            {
                                this.this$1 = var1_1;
                                this.val$tSelection = iStructuredSelection;
                                super($anonymous0);
                            }

                            public void run() {
                                PropertyData data = (PropertyData)this.val$tSelection.getFirstElement();
                                7.access$0(this.this$1).editProperty(data);
                            }
                        };
                        manager.add((IAction)tAction);
                        tAction.setEnabled(isEditAllowed && tSelection.size() == 1);
                        tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("PropertiesComposite.Remove"), tSelection){
                            final /* synthetic */ 7 this$1;
                            private final /* synthetic */ IStructuredSelection val$tSelection;
                            {
                                this.this$1 = var1_1;
                                this.val$tSelection = iStructuredSelection;
                                super($anonymous0);
                            }

                            public void run() {
                                PropertyData[] data = this.val$tSelection.toList().toArray(new PropertyData[this.val$tSelection.size()]);
                                7.access$0(this.this$1).removeProperty(data);
                            }
                        };
                        manager.add((IAction)tAction);
                        tAction.setEnabled(isEditAllowed && tSelection.size() > 0);
                        manager.add((IContributionItem)new Separator());
                        tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("PropertiesComposite.SetKeywords")){
                            final /* synthetic */ 7 this$1;
                            {
                                this.this$1 = var1_1;
                                super($anonymous0);
                            }

                            public void run() {
                                7.access$0(this.this$1).setKeywords();
                            }
                        };
                        manager.add((IAction)tAction);
                        tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("PropertiesComposite.ApplyRecursively"), tSelection){
                            final /* synthetic */ 7 this$1;
                            private final /* synthetic */ IStructuredSelection val$tSelection;
                            {
                                this.this$1 = var1_1;
                                this.val$tSelection = iStructuredSelection;
                                super($anonymous0);
                            }

                            public void run() {
                                PropertyData[] data = this.val$tSelection.toList().toArray(new PropertyData[this.val$tSelection.size()]);
                                7.access$0(this.this$1).setPropertyRecursive(data);
                            }
                        };
                        manager.add((IAction)tAction);
                        tAction.setEnabled(isEditAllowed && tSelection.size() > 0 && PropertiesComposite.this.wcResource instanceof IContainer);
                    }
                    tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("PropertiesComposite.SaveValueToFile"), tSelection){
                        final /* synthetic */ 7 this$1;
                        private final /* synthetic */ IStructuredSelection val$tSelection;
                        {
                            this.this$1 = var1_1;
                            this.val$tSelection = iStructuredSelection;
                            super($anonymous0);
                        }

                        public void run() {
                            PropertyData data = (PropertyData)this.val$tSelection.getFirstElement();
                            7.access$0(this.this$1).saveValueToFile(data);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(PropertiesComposite.this.provider != null && tSelection.size() == 1);
                    manager.add((IContributionItem)new Separator());
                    tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("PropertiesComposite.Refresh")){
                        final /* synthetic */ 7 this$1;
                        {
                            this.this$1 = var1_1;
                            super($anonymous0);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            PropertiesComposite propertiesComposite = 7.access$0(this.this$1);
                            synchronized (propertiesComposite) {
                                if (7.access$0(this.this$1).repositoryResource != null) {
                                    7.access$0(this.this$1).provider = new GetRemotePropertiesOperation(7.access$0(this.this$1).repositoryResource);
                                }
                                CompositeOperation composite = new CompositeOperation("Operation.PRefresh");
                                if (7.access$0(this.this$1).provider != null && 7.access$0(this.this$1).provider.getExecutionState() != 0) {
                                    composite.add((IActionOperation)7.access$0(this.this$1).provider);
                                    composite.add(7.access$0(this.this$1).getRefreshViewOperation(), new IActionOperation[]{7.access$0(this.this$1).provider});
                                } else {
                                    composite.add(7.access$0(this.this$1).getRefreshViewOperation());
                                }
                                UIMonitorUtility.doTaskScheduledActive((IActionOperation)composite);
                            }
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/refresh.gif"));
                    tAction.setEnabled(PropertiesComposite.this.provider != null);
                }
            }

            static /* synthetic */ PropertiesComposite access$0(7 var0) {
                return var0.PropertiesComposite.this;
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        table.setMenu(menu);
        this.propertyViewer.addDoubleClickListener(new IDoubleClickListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doubleClick(DoubleClickEvent e) {
                PropertiesComposite propertiesComposite = PropertiesComposite.this;
                synchronized (propertiesComposite) {
                    IStructuredSelection selection;
                    if (PropertiesComposite.this.provider != null && PropertiesComposite.this.provider.isEditAllowed() && (selection = (IStructuredSelection)e.getSelection()).size() == 1) {
                        PropertyData data = (PropertyData)selection.getFirstElement();
                        PropertiesComposite.this.editProperty(data);
                    }
                }
            }
        });
    }

    protected void removeProperty(PropertyData[] data) {
        RemovePropertyDialog dialog = new RemovePropertyDialog(this.getShell(), data.length == 1, this.wcResource instanceof IFile);
        if (dialog.open() != 0) {
            return;
        }
        CompositeOperation composite = new CompositeOperation("Operation.PRemoveProperty");
        composite.add((IActionOperation)new RemovePropertiesOperation(new IResource[]{this.wcResource}, data, dialog.isRecursive()));
        composite.add(this.getRefreshOperation(dialog.isRecursive() ? 2 : 0));
        UIMonitorUtility.doTaskScheduledActive((IActionOperation)composite);
    }

    protected void setKeywords() {
        SetKeywordsAction.doSetKeywords(new IResource[]{this.wcResource});
    }

    protected void setPropertyRecursive(PropertyData[] data) {
        PropertyApplyPanel panel = new PropertyApplyPanel(data.length == 1);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            SetPropertyAction.doSetProperty(new IResource[]{this.wcResource}, data, null, true, panel.getApplyMethod(), panel.useMask(), panel.getFilterMask(), this.getRefreshViewOperation());
        }
    }

    protected void editProperty(PropertyData data) {
        SetPropertyWithOverrideDialog overrideDialog;
        boolean propertyAlreadyExists = false;
        boolean override = true;
        IResource[] resources = new IResource[]{this.wcResource};
        PropertyEditPanel panel = new PropertyEditPanel(data, resources);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() != 0) {
            return;
        }
        int i = 0;
        while (i < this.properties.length) {
            if (this.properties[i].name.equals(panel.getPropertyName())) {
                propertyAlreadyExists = true;
                break;
            }
            ++i;
        }
        if (propertyAlreadyExists && data == null && (overrideDialog = new SetPropertyWithOverrideDialog(this.getShell(), panel.getPropertyName())).open() != 0) {
            override = false;
        }
        if (override) {
            SetPropertyAction.doSetProperty(resources, panel, this.getRefreshViewOperation());
        }
    }

    protected void saveValueToFile(final PropertyData data) {
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setFileName(data.name);
        final String fileName = fileDialog.open();
        AbstractNonLockingOperation saveValue = new AbstractNonLockingOperation("Operation.PSaveValueToFile"){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                FileOutputStream output = null;
                if (fileName != null) {
                    output = new FileOutputStream(fileName);
                    byte[] value = data.value.getBytes();
                    output.write(value);
                }
                if (output != null) {
                    output.close();
                }
            }
        };
        UIMonitorUtility.doTaskBusyDefault((IActionOperation)saveValue);
    }

    protected IActionOperation getRefreshOperation(int depth) {
        CompositeOperation composite = new CompositeOperation("Operation.PRefreshView");
        composite.add(this.getRefreshViewOperation());
        if (this.wcResource != null) {
            composite.add((IActionOperation)new RefreshResourcesOperation(new IResource[]{this.wcResource}, 2, RefreshResourcesOperation.REFRESH_ALL));
        }
        return composite;
    }

    public void initializeComposite() {
        this.propertyViewer.setInput((Object)this.properties);
        this.propertyViewer.getTable().setLinesVisible(true);
        this.propertyText.setText("");
    }

    public synchronized void disconnectComposite() {
        this.wcResource = null;
        this.properties = null;
        this.provider = null;
    }
}

