/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.composite;

import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.ISVNProgressMonitor;
import org.polarion.team.svn.core.client.Info2;
import org.polarion.team.svn.core.client.LogMessage;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.extension.CoreExtensionsManager;
import org.polarion.team.svn.core.operation.AbstractActionOperation;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.IResourcePropertyProvider;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.remote.GetLogMessagesOperation;
import org.polarion.team.svn.core.operation.remote.GetRemotePropertiesOperation;
import org.polarion.team.svn.core.resource.IRepositoryContainer;
import org.polarion.team.svn.core.resource.IRepositoryFile;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryResourceProvider;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.composite.LogMessagesComposite;
import org.polarion.team.svn.ui.history.AffectedPathNode;
import org.polarion.team.svn.ui.history.AffectedPathsContentProvider;
import org.polarion.team.svn.ui.history.AffectedPathsLabelProvider;
import org.polarion.team.svn.ui.operation.CompareRepositoryResourcesOperation;
import org.polarion.team.svn.ui.operation.OpenRemoteFileOperation;
import org.polarion.team.svn.ui.operation.ShowPropertiesOperation;
import org.polarion.team.svn.ui.utility.TableViewerSorter;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class AffectedPathsComposite
extends Composite {
    protected SashForm sashForm;
    protected TableViewer tableViewer;
    protected Table table;
    protected TreeViewer treeViewer;
    protected IRepositoryResource repositoryResource;
    protected long currentRevision;
    protected MenuManager treeViewerMenuManager;
    protected MenuManager tableViewerMenuManager;
    protected AffectedPathsLabelProvider labelProvider;

    public AffectedPathsComposite(Composite parent, int style) {
        super(parent, style);
        this.createControls();
    }

    public void setResourceTreeVisible(boolean visible) {
        if (visible) {
            this.sashForm.setMaximizedControl(null);
        } else {
            this.sashForm.setMaximizedControl(this.tableViewer.getControl());
            AffectedPathsContentProvider provider = (AffectedPathsContentProvider)this.treeViewer.getContentProvider();
            AffectedPathNode rootNode = provider.getRoot();
            if (rootNode != null) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)rootNode));
            }
        }
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    protected void createControls() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.sashForm = new SashForm((Composite)this, 256);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.treeViewer = new TreeViewer((Composite)this.sashForm, 768);
        this.treeViewer.setContentProvider((IContentProvider)new AffectedPathsContentProvider());
        this.labelProvider = new AffectedPathsLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){
            protected Object oldSelection;

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection tSelection = (IStructuredSelection)AffectedPathsComposite.this.treeViewer.getSelection();
                if (tSelection.size() > 0) {
                    Object selection = tSelection.getFirstElement();
                    if (this.oldSelection != selection) {
                        AffectedPathsComposite.this.tableViewer.setInput((Object)AffectedPathsComposite.this.getSelectedTreeItemPathData());
                        this.oldSelection = selection;
                    }
                } else {
                    AffectedPathsComposite.this.tableViewer.setInput(null);
                }
            }
        });
        this.table = new Table((Composite)this.sashForm, 66308);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData data = new GridData(1808);
        this.table.setLayoutData((Object)data);
        this.table.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                TableItem item = AffectedPathsComposite.this.table.getItem(new Point(e.x, e.y));
                if (item != null) {
                    Rectangle rect = item.getBounds(0);
                    AffectedPathsComposite.this.table.setToolTipText(rect.contains(e.x, e.y) ? (String)((Object[])item.getData())[0] : "");
                }
            }
        });
        this.table.redraw();
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(this.table);
        this.sashForm.setWeights(new int[]{25, 75});
        TableViewerSorter sorter = new TableViewerSorter(this.tableViewer, new TableViewerSorter.IColumnComparator(){

            public int compare(Object row1, Object row2, int column) {
                String[] rowData1 = (String[])row1;
                String[] rowData2 = (String[])row2;
                if (column == 4) {
                    Long rData1 = new Long(rowData1[column] == "" ? "0" : rowData1[column]);
                    Long rData2 = new Long(rowData2[column] == "" ? "0" : rowData2[column]);
                    return rData1.compareTo(rData2);
                }
                return TableViewerSorter.compare(rowData1[column], rowData2[column]);
            }
        });
        this.tableViewer.setSorter((ViewerSorter)sorter);
        TableColumn col = new TableColumn(this.table, 0);
        col.setText("");
        col.setResizable(false);
        col.addSelectionListener((SelectionListener)sorter);
        col.setAlignment(0x1000000);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(0, 26, false));
        col = new TableColumn(this.table, 0);
        col.setText(SVNTeamUIPlugin.instance().getResource("AffectedPathsComposite.Name"));
        col.addSelectionListener((SelectionListener)sorter);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TableColumn(this.table, 0);
        col.setText(SVNTeamUIPlugin.instance().getResource("AffectedPathsComposite.Path"));
        col.addSelectionListener((SelectionListener)sorter);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(35, true));
        col = new TableColumn(this.table, 0);
        col.setText(SVNTeamUIPlugin.instance().getResource("AffectedPathsComposite.CopiedFrom"));
        col.addSelectionListener((SelectionListener)sorter);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, true));
        col = new TableColumn(this.table, 0);
        col.setText(SVNTeamUIPlugin.instance().getResource("AffectedPathsComposite.CopiedFromRevision"));
        col.setAlignment(131072);
        col.addSelectionListener((SelectionListener)sorter);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(23, true));
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        ITableLabelProvider labelProvider = new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    String action = ((String[])element)[columnIndex];
                    switch (action.charAt(0)) {
                        case 'A': {
                            return LogMessagesComposite.ADDED_FILE_IMAGE;
                        }
                        case 'M': {
                            return LogMessagesComposite.MODIFIED_FILE_IMAGE;
                        }
                        case 'D': {
                            return LogMessagesComposite.DELETED_FILE_IMAGE;
                        }
                        case 'R': {
                            return LogMessagesComposite.REPLACED_FILE_IMAGE;
                        }
                    }
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 3) {
                    String copiedFrom = ((String[])element)[columnIndex];
                    return copiedFrom.length() > 1 && copiedFrom.startsWith("/") ? copiedFrom.substring(1) : copiedFrom;
                }
                return columnIndex != 0 ? ((String[])element)[columnIndex] : "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
        this.tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    protected String[][] getSelectedTreeItemPathData() {
        IStructuredSelection tSelection;
        Object selected = null;
        if (this.treeViewer != null && (tSelection = (IStructuredSelection)this.treeViewer.getSelection()).size() > 0) {
            selected = tSelection.getFirstElement();
        }
        return selected != null ? ((AffectedPathNode)selected).getPathData() : null;
    }

    public void setInput(String[][] input, Collection relatedPathPrefixes, Collection relatedParents, long currentRevision) {
        this.currentRevision = currentRevision;
        this.labelProvider.setCurrentRevision(currentRevision);
        AffectedPathsContentProvider provider = (AffectedPathsContentProvider)this.treeViewer.getContentProvider();
        provider.initialize(input, relatedPathPrefixes, relatedParents, this.currentRevision);
        if (input != null && (input.length > 0 || currentRevision == 0L)) {
            this.treeViewer.setInput((Object)"Root");
            this.treeViewer.expandAll();
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)provider.getRoot()));
            ((Tree)this.treeViewer.getControl()).showSelection();
        } else {
            this.treeViewer.setInput(null);
        }
    }

    public void registerMenuManager(IWorkbenchPartSite site) {
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                IStructuredSelection structured;
                ISelection selection = e.getSelection();
                if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
                    AffectedPathsComposite.this.openRemoteResource(structured);
                }
            }
        });
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.tableViewer.getTable());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                boolean enabled = false;
                manager.add((IContributionItem)new Separator("additions"));
                IStructuredSelection affectedTableSelection = (IStructuredSelection)AffectedPathsComposite.this.tableViewer.getSelection();
                if (affectedTableSelection.size() == 1) {
                    String status = ((String[])affectedTableSelection.getFirstElement())[0];
                    enabled = status.charAt(0) == 'M';
                }
                Action tAction = null;
                tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("AffectedPathsComposite.Open"), affectedTableSelection){
                    final /* synthetic */ 8 this$1;
                    private final /* synthetic */ IStructuredSelection val$affectedTableSelection;
                    {
                        this.this$1 = var1_1;
                        this.val$affectedTableSelection = iStructuredSelection;
                        super($anonymous0);
                    }

                    public void run() {
                        8.access$0(this.this$1).openRemoteResource(this.val$affectedTableSelection);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(affectedTableSelection.size() == 1);
                tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("AffectedPathsComposite.ShowProperties"), affectedTableSelection){
                    final /* synthetic */ 8 this$1;
                    private final /* synthetic */ IStructuredSelection val$affectedTableSelection;
                    {
                        this.this$1 = var1_1;
                        this.val$affectedTableSelection = iStructuredSelection;
                        super($anonymous0);
                    }

                    public void run() {
                        AffectedRepositoryResourceProvider provider = 8.access$0(this.this$1).new AffectedRepositoryResourceProvider(this.val$affectedTableSelection.getFirstElement(), false);
                        8.access$0(this.this$1).showProperties(provider);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(affectedTableSelection.size() == 1);
                tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("AffectedPathsComposite.CompareWithPreviousRevision"), affectedTableSelection){
                    final /* synthetic */ 8 this$1;
                    private final /* synthetic */ IStructuredSelection val$affectedTableSelection;
                    {
                        this.this$1 = var1_1;
                        this.val$affectedTableSelection = iStructuredSelection;
                        super($anonymous0);
                    }

                    public void run() {
                        AffectedRepositoryResourceProvider provider = 8.access$0(this.this$1).new AffectedRepositoryResourceProvider(this.val$affectedTableSelection.getFirstElement(), false);
                        8.access$0(this.this$1).compareWithPreviousRevision(provider);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(enabled);
            }

            static /* synthetic */ AffectedPathsComposite access$0(8 var0) {
                return var0.AffectedPathsComposite.this;
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.getTableViewer().getTable().setMenu(menu);
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewer);
        menuMgr = new MenuManager();
        menu = menuMgr.createContextMenu((Control)this.treeViewer.getTree());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
                IStructuredSelection affectedTableSelection = (IStructuredSelection)AffectedPathsComposite.this.treeViewer.getSelection();
                AffectedPathNode node = (AffectedPathNode)affectedTableSelection.getFirstElement();
                Action tAction = null;
                tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("AffectedPathsComposite.ShowProperties"), affectedTableSelection){
                    final /* synthetic */ 12 this$1;
                    private final /* synthetic */ IStructuredSelection val$affectedTableSelection;
                    {
                        this.this$1 = var1_1;
                        this.val$affectedTableSelection = iStructuredSelection;
                        super($anonymous0);
                    }

                    public void run() {
                        GetSelectedTreeResource provider = 12.access$0(this.this$1).new GetSelectedTreeResource(12.access$0(this.this$1).repositoryResource, 12.access$0(this.this$1).currentRevision, this.val$affectedTableSelection.getFirstElement());
                        12.access$0(this.this$1).showProperties(provider);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(AffectedPathsComposite.this.currentRevision != 0L && affectedTableSelection.size() == 1);
                tAction = new Action(this, SVNTeamUIPlugin.instance().getResource("AffectedPathsComposite.CompareWithPreviousRevision"), affectedTableSelection){
                    final /* synthetic */ 12 this$1;
                    private final /* synthetic */ IStructuredSelection val$affectedTableSelection;
                    {
                        this.this$1 = var1_1;
                        this.val$affectedTableSelection = iStructuredSelection;
                        super($anonymous0);
                    }

                    public void run() {
                        GetSelectedTreeResource provider = 12.access$0(this.this$1).new GetSelectedTreeResource(12.access$0(this.this$1).repositoryResource, 12.access$0(this.this$1).currentRevision, this.val$affectedTableSelection.getFirstElement());
                        12.access$0(this.this$1).compareWithPreviousRevision(provider);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(AffectedPathsComposite.this.currentRevision != 0L && affectedTableSelection.size() == 1 && (node.getStatus() == null || node.getStatus().charAt(0) == 'M') && CoreExtensionsManager.instance().getSVNClientWrapperFactory().isCompareFoldersAllowed());
            }

            static /* synthetic */ AffectedPathsComposite access$0(12 var0) {
                return var0.AffectedPathsComposite.this;
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.treeViewer.getTree().setMenu(menu);
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    protected void openRemoteResource(IStructuredSelection affectedTableSelection) {
        AffectedRepositoryResourceProvider provider = new AffectedRepositoryResourceProvider(affectedTableSelection.getFirstElement(), true);
        OpenRemoteFileOperation openOp = new OpenRemoteFileOperation(provider, 0);
        CompositeOperation composite = new CompositeOperation(openOp.getId());
        composite.add((IActionOperation)provider);
        composite.add((IActionOperation)openOp, new IActionOperation[]{provider});
        UIMonitorUtility.doTaskScheduledActive((IActionOperation)composite);
    }

    protected void showProperties(IRepositoryResourceProvider provider) {
        GetRemotePropertiesOperation propertyProvider = new GetRemotePropertiesOperation(provider);
        ShowPropertiesOperation showOp = new ShowPropertiesOperation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), provider, (IResourcePropertyProvider)propertyProvider);
        CompositeOperation composite = new CompositeOperation(showOp.getId());
        composite.add((IActionOperation)((AbstractActionOperation)provider));
        composite.add((IActionOperation)propertyProvider, new IActionOperation[]{(AbstractActionOperation)provider});
        composite.add((IActionOperation)showOp, new IActionOperation[]{(AbstractActionOperation)provider, propertyProvider});
        UIMonitorUtility.doTaskScheduledActive((IActionOperation)composite);
    }

    protected void compareWithPreviousRevision(AbstractActionOperation provider) {
        GetLogMessagesOperation msgsOp = new GetLogMessagesOperation((IRepositoryResourceProvider)provider);
        msgsOp.setLimit(2L);
        GetResourcesToCompareOperation getResourcesOp = new GetResourcesToCompareOperation("Operation.GetResourcesToCompare", msgsOp, (IRepositoryResourceProvider)provider);
        CompositeOperation composite = new CompositeOperation(getResourcesOp.getId());
        composite.add((IActionOperation)provider);
        composite.add((IActionOperation)msgsOp, new IActionOperation[]{provider});
        composite.add((IActionOperation)getResourcesOp, new IActionOperation[]{msgsOp});
        composite.add((IActionOperation)new CompareRepositoryResourcesOperation(getResourcesOp), new IActionOperation[]{getResourcesOp});
        UIMonitorUtility.doTaskScheduledActive((IActionOperation)composite);
    }

    public IRepositoryResource getRepositoryResource() {
        return this.repositoryResource;
    }

    public void setRepositoryResource(IRepositoryResource repositoryResource) {
        this.repositoryResource = repositoryResource;
    }

    protected class GetSelectedTreeResource
    extends AbstractActionOperation
    implements IRepositoryResourceProvider {
        protected IRepositoryResource repositoryResource;
        protected long currentRevision;
        protected Object affectedPathsItem;
        protected IRepositoryResource returnResource;

        public GetSelectedTreeResource(IRepositoryResource repositoryResource, long currentRevision, Object affectedPathsItem) {
            super("Get Selected Tree Resource");
            this.repositoryResource = repositoryResource;
            this.currentRevision = currentRevision;
            this.affectedPathsItem = affectedPathsItem;
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            String rootUrl = this.repositoryResource.getRepositoryLocation().getRepositoryRootUrl();
            String path = ((AffectedPathNode)this.affectedPathsItem).getFullPath();
            String resourceUrl = String.valueOf(rootUrl) + (path.startsWith("/") ? "" : "/") + path;
            IRepositoryLocation location = this.repositoryResource.getRepositoryLocation();
            this.returnResource = location.asRepositoryContainer(resourceUrl, false);
            this.returnResource.setSelectedRevision(Revision.getInstance((long)this.currentRevision));
            this.returnResource.setPegRevision(Revision.getInstance((long)this.currentRevision));
        }

        public ISchedulingRule getSchedulingRule() {
            return null;
        }

        public IRepositoryResource[] getRepositoryResources() {
            return new IRepositoryResource[]{this.returnResource};
        }
    }

    protected class GetResourcesToCompareOperation
    extends AbstractNonLockingOperation
    implements IRepositoryResourceProvider {
        protected IRepositoryResourceProvider resourceProvider;
        protected IRepositoryResource remoteResource;
        protected GetLogMessagesOperation msgsOp;
        public IRepositoryResource right;

        public GetResourcesToCompareOperation(String operationName, GetLogMessagesOperation msgsOp, IRepositoryResourceProvider resourceProvider) {
            super(operationName);
            this.msgsOp = msgsOp;
            this.resourceProvider = resourceProvider;
            this.right = null;
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            this.remoteResource = this.resourceProvider.getRepositoryResources()[0];
            if (this.remoteResource == null) {
                return;
            }
            LogMessage[] msgs = this.msgsOp.getMessages();
            if (msgs != null && msgs.length == 2) {
                Revision previousRevNum = Revision.getInstance((long)msgs[1].revision);
                if (this.remoteResource instanceof IRepositoryContainer) {
                    this.right = this.remoteResource.getRepositoryLocation().asRepositoryContainer(this.remoteResource.getUrl(), false);
                } else if (this.remoteResource instanceof IRepositoryFile) {
                    this.right = this.remoteResource.getRepositoryLocation().asRepositoryFile(this.remoteResource.getUrl(), false);
                }
                this.right.setSelectedRevision(previousRevNum);
                this.right.setPegRevision(previousRevNum);
            } else {
                String message = SVNTeamUIPlugin.instance().getResource("Error.ResourceDoesNotExists");
                message = MessageFormat.format(message, this.remoteResource.getUrl());
                this.reportStatus((IStatus)new Status(4, "org.polarion.team.svn.core.svnnature", 0, message, null));
            }
        }

        public IRepositoryResource[] getRepositoryResources() {
            return new IRepositoryResource[]{this.remoteResource, this.right};
        }
    }

    protected class GetInfoOperation
    extends AbstractActionOperation {
        protected String url;
        protected long revNum;
        protected Info2 resourceInfo;

        public GetInfoOperation(String url, long revNum) {
            super("Operation.GetResourceInfo");
            this.url = url;
            this.revNum = revNum;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void runImpl(IProgressMonitor monitor) throws Exception {
            ISVNClientWrapper proxy = AffectedPathsComposite.this.repositoryResource.getRepositoryLocation().acquireSVNProxy();
            try {
                Revision rev = Revision.getInstance((long)this.revNum);
                Info2[] infos = proxy.info2(this.url, rev, rev, false, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)this, monitor, null));
                if (infos != null && infos.length > 0) {
                    this.resourceInfo = infos[0];
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                AffectedPathsComposite.this.repositoryResource.getRepositoryLocation().releaseSVNProxy(proxy);
                throw throwable;
            }
            {
                Object var5_7 = null;
            }
            AffectedPathsComposite.this.repositoryResource.getRepositoryLocation().releaseSVNProxy(proxy);
        }

        public ISchedulingRule getSchedulingRule() {
            return null;
        }

        public Info2 getResourceInfo() {
            return this.resourceInfo;
        }
    }

    protected class AffectedRepositoryResourceProvider
    extends AbstractActionOperation
    implements IRepositoryResourceProvider {
        protected IRepositoryResource repositoryResource;
        protected Object affectedPathsItem;
        protected boolean filesOnly;

        public AffectedRepositoryResourceProvider(Object affectedPathsItem, boolean filesOnly) {
            super("Operation.GetRepositoryResource");
            this.affectedPathsItem = affectedPathsItem;
            this.filesOnly = filesOnly;
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            String path = ((String[])this.affectedPathsItem)[2];
            String name = ((String[])this.affectedPathsItem)[1];
            if (path.trim().length() == 0 && name.equals("ROOT")) {
                name = "";
            }
            String affectedPath = String.valueOf(path) + "/" + name;
            String rootUrl = AffectedPathsComposite.this.repositoryResource.getRepositoryLocation().getRepositoryRootUrl();
            String resourceUrl = String.valueOf(rootUrl) + "/" + affectedPath;
            long revision = AffectedPathsComposite.this.currentRevision;
            if (((String[])this.affectedPathsItem)[0].charAt(0) == 'D') {
                revision = AffectedPathsComposite.this.currentRevision - 1L;
            }
            GetInfoOperation infoOp = new GetInfoOperation(resourceUrl, revision);
            UIMonitorUtility.doTaskBusyDefault((IActionOperation)infoOp);
            this.reportStatus(infoOp.getStatus());
            if (infoOp.getStatus().isOK()) {
                Info2 info = infoOp.getResourceInfo();
                IRepositoryLocation location = AffectedPathsComposite.this.repositoryResource.getRepositoryLocation();
                if (info != null) {
                    if (info.kind == 2 && this.filesOnly) {
                        String message = MessageFormat.format(SVNTeamUIPlugin.instance().getResource("AffectedPathsComposite.Open.Message"), SVNUtility.decodeURL((String)info.url));
                        UIMonitorUtility.getDisplay().syncExec(new Runnable(this, message){
                            final /* synthetic */ AffectedRepositoryResourceProvider this$1;
                            private final /* synthetic */ String val$message;
                            {
                                this.this$1 = affectedRepositoryResourceProvider;
                                this.val$message = string;
                            }

                            public void run() {
                                MessageDialog dialog = new MessageDialog(UIMonitorUtility.getDisplay().getActiveShell(), SVNTeamUIPlugin.instance().getResource("AffectedPathsComposite.Open.Title"), null, this.val$message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                                dialog.open();
                            }
                        });
                        return;
                    }
                    this.repositoryResource = info.kind == 1 ? location.asRepositoryFile(resourceUrl, false) : location.asRepositoryContainer(resourceUrl, false);
                    this.repositoryResource.setSelectedRevision(Revision.getInstance((long)revision));
                    this.repositoryResource.setPegRevision(Revision.getInstance((long)revision));
                }
            }
        }

        public ISchedulingRule getSchedulingRule() {
            return null;
        }

        public IRepositoryResource[] getRepositoryResources() {
            return new IRepositoryResource[]{this.repositoryResource};
        }
    }
}

