/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.compare;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.remote.LocateResourceURLInHistoryOperation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.compare.ResourceCompareInput;
import org.polarion.team.svn.ui.utility.OverlayedImageDescriptor;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class TwoWayResourceCompareInput
extends ResourceCompareInput {
    protected Status[] statuses;

    public TwoWayResourceCompareInput(CompareConfiguration configuration, IRepositoryResource leftResource, IRepositoryResource rightResource, Status[] statuses) {
        super(configuration);
        this.rootLeft = SVNUtility.copyOf((IRepositoryResource)leftResource);
        this.rootRight = SVNUtility.copyOf((IRepositoryResource)rightResource);
        this.statuses = statuses;
    }

    public void initialize(IProgressMonitor monitor) throws Exception {
        super.initialize(monitor);
        SVNUtility.reorder((Status[])this.statuses, (boolean)true);
        HashMap<Path, CompareNode> path2node = new HashMap<Path, CompareNode>();
        String message = SVNTeamUIPlugin.instance().getResource("ResourceCompareInput.CheckingDelta");
        int i = 0;
        while (i < this.statuses.length) {
            monitor.subTask(MessageFormat.format(message, SVNUtility.decodeURL((String)this.statuses[i].path)));
            CompareNode node = this.makeNode(this.statuses[i], path2node, monitor);
            path2node.put(new Path(((ResourceCompareInput.ResourceElement)node.getRight()).getRepositoryResource().getUrl()), node);
            ProgressMonitorUtility.progress((IProgressMonitor)monitor, (int)i, (int)this.statuses.length);
            ++i;
        }
        this.findRootNode(path2node, this.rootRight, monitor);
        if (this.root == null) {
            this.findRootNode(path2node, this.rootLeft, monitor);
        }
    }

    protected void findRootNode(Map path2node, IRepositoryResource resource, IProgressMonitor monitor) {
        this.root = (CompareNode)((Object)path2node.get(new Path(resource.getUrl())));
        if (this.root == null && !path2node.isEmpty()) {
            LocateResourceURLInHistoryOperation op = new LocateResourceURLInHistoryOperation(new IRepositoryResource[]{resource}, false);
            UIMonitorUtility.doTaskExternalDefault((IActionOperation)op, monitor);
            IRepositoryResource converted = op.getRepositoryResources()[0];
            this.root = (CompareNode)((Object)path2node.get(new Path(converted.getUrl())));
        }
    }

    protected CompareNode makeNode(Status st, Map path2node, IProgressMonitor monitor) throws Exception {
        String url = SVNUtility.decodeURL((String)st.url);
        int nodeKind = this.getNodeKind(st);
        IRepositoryResource left = this.createResourceFor(this.rootLeft.getRepositoryLocation(), nodeKind, url);
        left.setSelectedRevision(this.rootLeft.getSelectedRevision());
        left.setPegRevision(this.rootLeft.getPegRevision());
        IRepositoryResource right = this.createResourceFor(this.rootRight.getRepositoryLocation(), nodeKind, url);
        right.setSelectedRevision(this.rootRight.getSelectedRevision());
        right.setPegRevision(this.rootRight.getPegRevision());
        LocateResourceURLInHistoryOperation op = new LocateResourceURLInHistoryOperation(new IRepositoryResource[]{left, right}, true);
        ProgressMonitorUtility.doTaskExternal((IActionOperation)op, (IProgressMonitor)monitor);
        left = op.getRepositoryResources()[0];
        right = op.getRepositoryResources()[1];
        IDiffContainer parent = this.getParentCompareNode(right, path2node);
        int diffKind = ResourceCompareInput.getDiffKind(st.textStatus, st.propStatus, 1);
        diffKind = diffKind == 2 ? 1 : (diffKind == 1 ? 2 : diffKind);
        return new CompareNode(parent, diffKind, left, right, st.textStatus == 1 ? st.propStatus : st.textStatus);
    }

    protected IDiffContainer makeStubNode(IDiffContainer parent, IRepositoryResource node) {
        return new CompareNode(parent, 0, node, node, 1);
    }

    protected boolean isThreeWay() {
        return false;
    }

    protected ResourceCompareInput.ResourceCompareViewer createDiffViewerImpl(Composite parent, CompareConfiguration config) {
        return new ResourceCompareInput.ResourceCompareViewer(this, parent, config){

            public void setLabelProvider(IBaseLabelProvider labelProvider) {
                super.setLabelProvider((IBaseLabelProvider)new ResourceCompareInput.ResourceCompareViewer.LabelProviderWrapper(this, this, (ILabelProvider)labelProvider){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        super($anonymous0);
                    }

                    public Image getImage(Object element) {
                        if (element instanceof CompareNode && ((CompareNode)((Object)element)).getStatusKind() == 7) {
                            Image image = (Image)this.images.get(element);
                            if (image == null) {
                                OverlayedImageDescriptor imageDescriptor = new OverlayedImageDescriptor(this.baseProvider.getImage(element), SVNTeamUIPlugin.instance().getImageDescriptor("icons/overlays/replaced_2way.gif"), new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V);
                                image = imageDescriptor.createImage();
                                this.images.put(element, image);
                            }
                            return image;
                        }
                        return super.getImage(element);
                    }
                });
            }
        };
    }

    protected class CompareNode
    extends ResourceCompareInput.BaseCompareNode {
        protected int statusKind;

        public CompareNode(IDiffContainer parent, int kind, IRepositoryResource left, IRepositoryResource right, int statusKind) {
            super(parent, kind);
            this.statusKind = statusKind;
            this.setRight(new ResourceCompareInput.ResourceElement(right, statusKind == 3 ? 0 : 1));
            this.setLeft(new ResourceCompareInput.ResourceElement(left, statusKind == 4 ? 0 : 1));
        }

        public int getStatusKind() {
            return this.statusKind;
        }
    }
}

