/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.annotate;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.graphics.RGB;
import org.polarion.team.svn.core.client.LogMessage;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;

public class BuiltInAnnotateRevision
extends Revision {
    public static final int END_LINE = -1;
    protected String id;
    protected String author;
    private int startLine;
    private int stopLine;
    private String info;
    protected RGB color;
    protected LogMessage msg;

    public BuiltInAnnotateRevision(String id, String author, RGB color) {
        this.id = id;
        this.color = color;
        this.author = author;
        this.stopLine = -1;
        this.startLine = -1;
    }

    public void setLogMessage(LogMessage msg) {
        this.msg = msg;
    }

    public String getId() {
        return this.id;
    }

    public void addLine(int line) {
        if (this.startLine == -1) {
            this.startLine = this.stopLine = line;
        } else if (line == -1) {
            this.addRange((ILineRange)new LineRange(this.startLine - 1, this.stopLine - this.startLine + 1));
        } else if (line - this.stopLine == 1) {
            this.stopLine = line;
        } else {
            this.addRange((ILineRange)new LineRange(this.startLine - 1, this.stopLine - this.startLine + 1));
            this.startLine = this.stopLine = line;
        }
    }

    public RGB getColor() {
        return this.color;
    }

    public Object getHoverInfo() {
        if (this.info == null) {
            String message;
            this.info = "<b>" + SVNTeamUIPlugin.instance().getResource("BuiltInAnnotateRevision.Revision") + " </b>" + this.getId() + "<br>";
            if (this.author != null) {
                this.info = String.valueOf(this.info) + "<b>" + SVNTeamUIPlugin.instance().getResource("BuiltInAnnotateRevision.Author") + " </b>" + this.author;
            }
            if (this.getDate() != null) {
                DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
                this.info = String.valueOf(this.info) + "<br><b>" + SVNTeamUIPlugin.instance().getResource("BuiltInAnnotateRevision.Date") + " </b>" + dateTimeFormat.format(this.getDate());
            }
            String string = message = this.msg == null ? null : this.msg.message;
            if (message != null && message.length() > 0) {
                this.info = String.valueOf(this.info) + "<br><b>" + SVNTeamUIPlugin.instance().getResource("BuiltInAnnotateRevision.Message") + "</b><br>" + this.msg.message;
            }
        }
        return this.info;
    }

    public Date getDate() {
        Date date = this.msg == null || this.msg.date == 0L ? null : new Date(this.msg.date);
        return date == null ? new Date(0L) : date;
    }
}

