/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action.remote;

import org.eclipse.jface.action.IAction;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.remote.RenameResourceOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryRoot;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.operation.RefreshRemoteResourcesOperation;
import org.polarion.team.svn.ui.panel.remote.RenameResourcePanel;

public class RenameAction
extends AbstractRepositoryTeamAction {
    public void runImpl(IAction action) {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        RenameResourcePanel panel = new RenameResourcePanel(resources[0].getName());
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            RenameResourceOperation mainOp = new RenameResourceOperation(resources[0], panel.getResourceName(), panel.getMessage());
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RefreshRemoteResourcesOperation(SVNUtility.getCommonParents((IRepositoryResource[])resources)));
            this.runNow((IActionOperation)op, false);
        }
    }

    public boolean isEnabled() {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        int i = 0;
        while (i < resources.length) {
            IRepositoryLocation location = resources[i].getRepositoryLocation();
            if (resources[i].getUrl().equals(location.getRoot().getUrl()) || resources[i].getSelectedRevision().getKind() != 7 || resources[i] instanceof IRepositoryRoot && (((IRepositoryRoot)resources[i]).getKind() == 4 || ((IRepositoryRoot)resources[i]).getKind() == 0)) {
                return false;
            }
            ++i;
        }
        return resources.length == 1;
    }
}

