/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.polarion.team.svn.core.operation.AbstractActionOperation;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.remote.DeleteResourcesOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryRoot;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.operation.RefreshRemoteResourcesOperation;
import org.polarion.team.svn.ui.panel.common.CommentPanel;
import org.polarion.team.svn.ui.repository.RepositoriesView;

public class DeleteAction
extends AbstractRepositoryTeamAction {
    public void runImpl(IAction action) {
        CommentPanel commentPanel = new CommentPanel(SVNTeamUIPlugin.instance().getResource("DeleteAction.Comment.Title"));
        DefaultDialog dialog = new DefaultDialog(this.getShell(), commentPanel);
        if (dialog.open() == 0) {
            IRepositoryResource[] resources = this.getSelectedRepositoryResources();
            IRepositoryResource[] commonParents = SVNUtility.getCommonParents((IRepositoryResource[])resources);
            DeleteResourcesOperation mainOp = new DeleteResourcesOperation(resources, commentPanel.getMessage());
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RefreshRemoteResourcesOperation(commonParents));
            op.add((IActionOperation)new AbstractActionOperation(""){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    DeleteAction.this.getShell().getDisplay().syncExec(new Runnable(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            RepositoriesView view = RepositoriesView.instance();
                            if (view == null) {
                                return;
                            }
                            view.getRepositoryTree().fireEmptySelectionEvent();
                        }
                    });
                }

                public ISchedulingRule getSchedulingRule() {
                    return null;
                }
            });
            this.runScheduled((IActionOperation)op);
        }
    }

    public boolean isEnabled() {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        int i = 0;
        while (i < resources.length) {
            IRepositoryLocation location = resources[i].getRepositoryLocation();
            if (resources[i].getUrl().equals(location.getRoot().getUrl()) || resources[i].getSelectedRevision().getKind() != 7 || resources[i] instanceof IRepositoryRoot && (((IRepositoryRoot)resources[i]).getKind() == 4 || ((IRepositoryRoot)resources[i]).getKind() == 0)) {
                return false;
            }
            ++i;
        }
        return resources.length > 0;
    }
}

