/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action.remote;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.polarion.team.svn.core.client.ClientWrapperException;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.LoggedOperation;
import org.polarion.team.svn.core.operation.remote.PreparedBranchTagOperation;
import org.polarion.team.svn.core.resource.IRepositoryContainer;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryRoot;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.dialog.OperationErrorDialog;
import org.polarion.team.svn.ui.operation.GetRemoteFolderChildrenOperation;
import org.polarion.team.svn.ui.operation.RefreshRemoteResourcesOperation;
import org.polarion.team.svn.ui.panel.common.AbstractBranchTagPanel;
import org.polarion.team.svn.ui.panel.common.BranchPanel;
import org.polarion.team.svn.ui.panel.common.TagPanel;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.utility.DefaultOperationWrapperFactory;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class BranchTagAction
extends AbstractRepositoryTeamAction {
    public static final int BRANCH_ACTION = 0;
    public static final int TAG_ACTION = 1;
    protected int nodeType;

    public BranchTagAction(int nodeType) {
        this.nodeType = nodeType;
    }

    public void runImpl(IAction action) {
        boolean respectProjectStructure = SVNTeamPreferences.getRepositoryBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "tagConsideringProjectStructure");
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        PreparedBranchTagOperation op = BranchTagAction.getBranchTagOperation(resources, this.getShell(), this.nodeType, respectProjectStructure);
        if (op != null) {
            CompositeOperation composite = new CompositeOperation(op.getId());
            composite.add((IActionOperation)op);
            RefreshRemoteResourcesOperation refreshOp = new RefreshRemoteResourcesOperation(new IRepositoryResource[]{op.getDestination().getParent()});
            composite.add((IActionOperation)refreshOp, new IActionOperation[]{op});
            this.runScheduled((IActionOperation)composite);
        }
    }

    public static boolean replaceProjectRootsWithTrunk(IRepositoryResource[] resources) {
        IRepositoryLocation location = resources[0].getRepositoryLocation();
        if (location.isStructureEnabled() && resources[0] instanceof IRepositoryContainer) {
            IRepositoryResource parent = resources[0].getParent();
            if (parent instanceof IRepositoryRoot && ((IRepositoryRoot)parent).getKind() == 1) {
                return !BranchTagAction.isSingleProjectLayout((IRepositoryRoot)parent);
            }
            IRepositoryResource[] children = BranchTagAction.getRemoteChildren((IRepositoryContainer)resources[0]);
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof IRepositoryRoot && ((IRepositoryRoot)children[i]).getKind() == 1) {
                        resources[0] = (IRepositoryRoot)children[i];
                        break;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public static Set getExistingNodeNames(IRepositoryContainer parent) {
        HashSet<String> nodeNames = new HashSet<String>();
        IRepositoryResource[] existentNodes = BranchTagAction.getRemoteChildren(parent);
        if (existentNodes != null) {
            int i = 0;
            while (i < existentNodes.length) {
                nodeNames.add(existentNodes[i].getName());
                ++i;
            }
        }
        return nodeNames;
    }

    public static PreparedBranchTagOperation getBranchTagOperation(IRepositoryResource[] resources, Shell shell, int nodeType, boolean respectProjectStructure) {
        boolean multipleProjLayout = BranchTagAction.replaceProjectRootsWithTrunk(resources);
        if (!OperationErrorDialog.isAcceptableAtOnce(resources, SVNTeamUIPlugin.instance().getResource(nodeType == 0 ? "BranchTagAction.Error.Branch" : "BranchTagAction.Error.Tag"), shell)) {
            return null;
        }
        Set nodeNames = null;
        nodeNames = respectProjectStructure && resources[0].getRepositoryLocation().isStructureEnabled() ? BranchTagAction.getExistingNodeNames((IRepositoryContainer)(nodeType == 0 ? SVNUtility.getBranchesLocation((IRepositoryResource)resources[0]) : SVNUtility.getTagsLocation((IRepositoryResource)resources[0]))) : new HashSet();
        AbstractBranchTagPanel panel = nodeType == 0 ? new BranchPanel(SVNUtility.getBranchesLocation((IRepositoryResource)resources[0]), false, nodeNames) : new TagPanel(SVNUtility.getTagsLocation((IRepositoryResource)resources[0]), false, nodeNames);
        DefaultDialog dialog = new DefaultDialog(shell, panel);
        if (dialog.open() == 0) {
            IRepositoryResource destination = panel.getDestination();
            return new PreparedBranchTagOperation(nodeType == 0 ? "Branch" : "Tag", resources, destination, panel.getMessage(), multipleProjLayout);
        }
        return null;
    }

    protected static boolean isSingleProjectLayout(IRepositoryRoot trunk) {
        try {
            return trunk.asRepositoryFile(String.valueOf(trunk.getUrl()) + "/.project", false).exists();
        }
        catch (ClientWrapperException clientWrapperException) {
            return false;
        }
    }

    protected static IRepositoryResource[] getRemoteChildren(IRepositoryContainer parent) {
        GetRemoteFolderChildrenOperation op = new GetRemoteFolderChildrenOperation(parent, false);
        UIMonitorUtility.doTaskBusy((IActionOperation)op, new DefaultOperationWrapperFactory(){

            public IActionOperation getLogged(IActionOperation operation) {
                return new LoggedOperation(operation);
            }
        });
        return op.getChildren();
    }

    public boolean isEnabled() {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        if (resources.length == 0) {
            return false;
        }
        IRepositoryLocation first = resources[0].getRepositoryLocation();
        int i = 1;
        while (i < resources.length) {
            if (first != resources[i].getRepositoryLocation()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

