/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action.local;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Shell;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.DetectDeletedProjectsOperation;
import org.polarion.team.svn.core.operation.local.IUnresolvedConflictDetector;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.UpdateOperation;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.svnstorage.ResourcesParentsProvider;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.action.AbstractRecursiveTeamAction;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.operation.ClearUpdateStatusesOperation;
import org.polarion.team.svn.ui.operation.NotifyUnresolvedConflictOperation;
import org.polarion.team.svn.ui.operation.ProcessDeletedProjectsOperation;
import org.polarion.team.svn.ui.panel.local.ResourceListPanel;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.utility.UnacceptableOperationNotificator;

public class UpdateAction
extends AbstractRecursiveTeamAction {
    public void runImpl(IAction action) {
        IResource[] missing;
        IResource[] resources = UnacceptableOperationNotificator.shrinkResourcesWithNotOnRespositoryParents(this.getShell(), this.getSelectedResources(IStateFilter.SF_ONREPOSITORY));
        if (resources == null || resources.length == 0) {
            return;
        }
        if (this.checkForResourcesPresenceRecursive(IStateFilter.SF_REVERTABLE) && (missing = this.getSelectedResourcesRecursive(IStateFilter.SF_MISSING)).length > 0 && !UpdateAction.updateMissing(this.getShell(), missing)) {
            return;
        }
        this.runScheduled((IActionOperation)UpdateAction.getUpdateOperation(this.getShell(), resources));
    }

    public boolean isEnabled() {
        return this.checkForResourcesPresence(IStateFilter.SF_ONREPOSITORY);
    }

    public static boolean updateMissing(Shell shell, IResource[] missing) {
        ResourceListPanel panel = new ResourceListPanel(missing, SVNTeamUIPlugin.instance().getResource("UpdateAction.List.Title"), SVNTeamUIPlugin.instance().getResource("UpdateAction.List.Description"), SVNTeamUIPlugin.instance().getResource("UpdateAction.List.Message"), new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL});
        panel.setShowLocalNames(true);
        return new DefaultDialog(shell, panel).open() == 0;
    }

    public static CompositeOperation getUpdateOperation(Shell shell, IResource[] updateSet) {
        if (SVNTeamPreferences.getResourceSelectionBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "detectDeleted")) {
            final DetectDeletedProjectsOperation detectOp = new DetectDeletedProjectsOperation(updateSet);
            final UpdateOperation mainOp = new UpdateOperation((IResourceProvider)detectOp, true);
            IResourceProvider refreshProvider = new IResourceProvider(){

                public IResource[] getResources() {
                    HashSet<IResource> fullSet = new HashSet<IResource>(Arrays.asList(mainOp.getResources()));
                    fullSet.addAll(Arrays.asList(detectOp.getDeleted()));
                    return fullSet.toArray(new IResource[fullSet.size()]);
                }
            };
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            op.add((IActionOperation)detectOp);
            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation((IResourceProvider)detectOp);
            op.add((IActionOperation)saveOp);
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
            op.add((IActionOperation)new ProcessDeletedProjectsOperation(detectOp));
            op.add((IActionOperation)new ClearUpdateStatusesOperation(refreshProvider));
            op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider(refreshProvider)));
            op.add((IActionOperation)new NotifyUnresolvedConflictOperation((IUnresolvedConflictDetector)mainOp));
            return op;
        }
        UpdateOperation mainOp = new UpdateOperation(updateSet, true);
        CompositeOperation op = new CompositeOperation(mainOp.getId());
        SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(updateSet);
        op.add((IActionOperation)saveOp);
        op.add((IActionOperation)mainOp);
        op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
        op.add((IActionOperation)new ClearUpdateStatusesOperation((IResourceProvider)mainOp));
        op.add((IActionOperation)new RefreshResourcesOperation((IResourceProvider)new ResourcesParentsProvider((IResourceProvider)mainOp)));
        op.add((IActionOperation)new NotifyUnresolvedConflictOperation((IUnresolvedConflictDetector)mainOp));
        return op;
    }
}

