/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.ClearLocalStatusesOperation;
import org.polarion.team.svn.core.operation.local.RefreshResourcesOperation;
import org.polarion.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.polarion.team.svn.core.operation.local.SwitchOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.action.AbstractNonRecursiveTeamAction;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.dialog.OperationErrorDialog;
import org.polarion.team.svn.ui.panel.local.SwitchPanel;

public class SwitchAction
extends AbstractNonRecursiveTeamAction {
    public void runImpl(IAction action) {
        SwitchPanel panel;
        IResource[] resources = this.getSelectedResources(IStateFilter.SF_EXCLUDE_DELETED);
        if (!OperationErrorDialog.isAcceptableAtOnce(resources, SVNTeamUIPlugin.instance().getResource("SwitchAction.Error"), this.getShell())) {
            return;
        }
        if (resources.length > 1) {
            IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource(resources[0]);
            remote = SVNUtility.getTrunkLocation((IRepositoryResource)remote);
            panel = new SwitchPanel(remote, -1L);
        } else {
            IResource resource = resources[0];
            IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource(resource);
            ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
            if (local == null) {
                return;
            }
            panel = new SwitchPanel(remote, local.getRevision());
        }
        DefaultDialog dialog = new DefaultDialog(this.getShell(), panel);
        if (dialog.open() == 0) {
            IRepositoryResource[] destinations = panel.getSelection(resources);
            SwitchOperation mainOp = new SwitchOperation(resources, destinations);
            CompositeOperation op = new CompositeOperation(mainOp.getId());
            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
            op.add((IActionOperation)saveOp);
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
            op.add((IActionOperation)new ClearLocalStatusesOperation(resources));
            op.add((IActionOperation)new RefreshResourcesOperation(resources));
            this.runScheduled((IActionOperation)op);
        }
    }

    public boolean isEnabled() {
        return this.checkForResourcesPresence(IStateFilter.SF_EXCLUDE_DELETED);
    }
}

