/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui.action.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.AbstractNonLockingOperation;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.local.property.GetMultiPropertiesOperation;
import org.polarion.team.svn.core.operation.local.property.IPropertyProvider;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.action.AbstractNonRecursiveTeamAction;
import org.polarion.team.svn.ui.dialog.DefaultDialog;
import org.polarion.team.svn.ui.panel.view.property.PropertyKeywordEditPanel;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class SetKeywordsAction
extends AbstractNonRecursiveTeamAction {
    public void runImpl(IAction action) {
        SetKeywordsAction.doSetKeywords(this.getSelectedResources(IStateFilter.SF_VERSIONED));
    }

    public static void doSetKeywords(final IResource[] resources) {
        if (!SVNTeamPreferences.getKeywordsBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "computeValues")) {
            SetKeywordsAction.queryUser(resources, new IResourceProvider(){

                public IResource[] getResources() {
                    return resources;
                }
            }, null);
        } else {
            CompositeOperation composite = new CompositeOperation("Operation.SetKeywordsProperty");
            final GetMultiPropertiesOperation getKeywordsOp = new GetMultiPropertiesOperation(resources, 2, IStateFilter.SF_EXCLUDE_PREREPLACED_AND_DELETED_FILES, "svn:keywords");
            composite.add((IActionOperation)getKeywordsOp);
            composite.add((IActionOperation)new AbstractNonLockingOperation(composite.getId()){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    if (!monitor.isCanceled()) {
                        SetKeywordsAction.queryUser(resources, (IResourceProvider)getKeywordsOp, (IPropertyProvider)getKeywordsOp);
                    }
                }
            });
            UIMonitorUtility.doTaskScheduledActive((IActionOperation)composite);
        }
    }

    protected static void queryUser(IResource[] resources, IResourceProvider resourceProvider, IPropertyProvider propertyProvider) {
        final PropertyKeywordEditPanel panel = new PropertyKeywordEditPanel(resources, resourceProvider, propertyProvider);
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                if (dialog.open() == 0) {
                    panel.performKeywordChanges();
                }
            }
        });
    }

    public boolean isEnabled() {
        return this.checkForResourcesPresenceRecursive(IStateFilter.SF_EXCLUDE_PREREPLACED_AND_DELETED_FILES);
    }
}

