/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui;

import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.polarion.team.svn.core.ICredentialsPrompt;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.extension.options.IOptionProvider;
import org.polarion.team.svn.core.operation.CompositeOperation;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.utility.ILoggedOperationFactory;
import org.polarion.team.svn.core.utility.StringMatcher;
import org.polarion.team.svn.ui.SVNTeamModificationValidator;
import org.polarion.team.svn.ui.SVNTeamUIPlugin;
import org.polarion.team.svn.ui.operation.RefreshRepositoryLocationsOperation;
import org.polarion.team.svn.ui.panel.callback.PromptCredentialsPanel;
import org.polarion.team.svn.ui.preferences.SVNTeamAutoPropsPreferencePage;
import org.polarion.team.svn.ui.preferences.SVNTeamPreferences;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class UIOptionProvider
implements IOptionProvider {
    private SVNTeamModificationValidator modificationValidator = new SVNTeamModificationValidator();

    public boolean getReportRevisionChange() {
        return SVNTeamPreferences.getSynchronizeBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "reportRevisionChange");
    }

    public ICredentialsPrompt getCredentialsPrompt() {
        return PromptCredentialsPanel.DEFAULT_PROMPT;
    }

    public ILoggedOperationFactory getLoggedOperationFactory() {
        return UIMonitorUtility.DEFAULT_FACTORY;
    }

    public void addProjectSetCapabilityProcessing(CompositeOperation op) {
        op.add((IActionOperation)new RefreshRepositoryLocationsOperation(false));
    }

    public boolean isAutomaticProjectShareEnabled() {
        return SVNTeamPreferences.getShareBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "enableAuto");
    }

    public IFileModificationValidator getFileModificationValidator() {
        return this.modificationValidator;
    }

    public String getSVNClientId() {
        return SVNTeamPreferences.getCoreString(SVNTeamUIPlugin.instance().getPreferenceStore(), "svnclient");
    }

    public String getDefaultBranchesName() {
        String retVal = SVNTeamPreferences.getRepositoryString(SVNTeamUIPlugin.instance().getPreferenceStore(), "branches");
        if (retVal == null || retVal.length() == 0) {
            retVal = "branches";
        }
        return retVal;
    }

    public String getDefaultTagsName() {
        String retVal = SVNTeamPreferences.getRepositoryString(SVNTeamUIPlugin.instance().getPreferenceStore(), "tags");
        if (retVal == null || retVal.length() == 0) {
            retVal = "tags";
        }
        return retVal;
    }

    public String getDefaultTrunkName() {
        String retVal = SVNTeamPreferences.getRepositoryString(SVNTeamUIPlugin.instance().getPreferenceStore(), "head");
        if (retVal == null || retVal.length() == 0) {
            retVal = "trunk";
        }
        return retVal;
    }

    public boolean isSVNCacheEnabled() {
        return SVNTeamPreferences.getDecorationBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "enable.cache");
    }

    public PropertyData[] getAutomaticProperties(String template) {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        Object[] autoProperties = SVNTeamAutoPropsPreferencePage.loadProperties(SVNTeamPreferences.getAutoPropertiesList(store, "autoproperties"));
        int i = 0;
        while (i < autoProperties.length) {
            StringMatcher matcher;
            SVNTeamAutoPropsPreferencePage.AutoProperty autoProperty = (SVNTeamAutoPropsPreferencePage.AutoProperty)autoProperties[i];
            if (autoProperty.enabled && (matcher = new StringMatcher(autoProperty.fileName)).match(template)) {
                if (autoProperty.properties.length() == 0) {
                    return new PropertyData[0];
                }
                String[] props = autoProperty.properties.split(";");
                PropertyData[] propertyData = new PropertyData[props.length];
                int j = 0;
                while (j < props.length) {
                    String[] propsNameValue = props[j].split("=");
                    propertyData[j] = new PropertyData(propsNameValue[0], propsNameValue.length == 1 ? "" : propsNameValue[1], new byte[0]);
                    ++j;
                }
                return propertyData;
            }
            ++i;
        }
        return new PropertyData[0];
    }

    public String getResource(String key) {
        return SVNTeamUIPlugin.instance().getResource(key);
    }
}

