/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.ui.utility.LockProposeUtility;
import org.polarion.team.svn.ui.utility.UIMonitorUtility;

public class SVNTeamModificationValidator
implements IFileModificationValidator {
    public IStatus validateEdit(IFile[] files, Object context) {
        IResource[] needsLockResources;
        if (FileUtility.isConnected((IResource)files[0]) && (needsLockResources = this.getNeedsLockResources((IResource[])files)).length > 0) {
            LockProposeUtility.proposeLock(needsLockResources, context == null ? UIMonitorUtility.getShell() : (Shell)context);
        }
        return Status.OK_STATUS;
    }

    public IStatus validateSave(IFile file) {
        return Status.OK_STATUS;
    }

    protected IResource[] getNeedsLockResources(IResource[] files) {
        ArrayList<IResource> returnResources = new ArrayList<IResource>();
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        IResource[] needsLockResources = FileUtility.getResourcesRecursive((IResource[])files, (IStateFilter)IStateFilter.SF_NEEDS_LOCK, (int)0);
        int i = 0;
        while (i < needsLockResources.length) {
            ILocalResource local = storage.asLocalResource(needsLockResources[i]);
            if (local != null && !local.isLocked()) {
                returnResources.add(needsLockResources[i]);
            }
            ++i;
        }
        return returnResources.toArray(new IResource[returnResources.size()]);
    }
}

