/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.utility;

import java.text.MessageFormat;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.LoggedOperation;
import org.polarion.team.svn.core.utility.ILoggedOperationFactory;
import org.polarion.team.svn.core.utility.SubProgressMonitorWithInfo;

public final class ProgressMonitorUtility {
    public static final int TOTAL_WORK = 100;

    public static Job doTaskScheduledDefault(IActionOperation runnable) {
        return ProgressMonitorUtility.doTaskScheduledDefault(runnable, true);
    }

    public static Job doTaskScheduled(IActionOperation runnable) {
        return ProgressMonitorUtility.doTaskScheduled(runnable, true);
    }

    public static Job doTaskScheduledDefault(IActionOperation runnable, boolean system) {
        return ProgressMonitorUtility.doTaskScheduled(runnable, ILoggedOperationFactory.DEFAULT, system);
    }

    public static Job doTaskScheduled(IActionOperation runnable, boolean system) {
        return ProgressMonitorUtility.doTaskScheduled(runnable, SVNTeamPlugin.instance().getOptionProvider().getLoggedOperationFactory(), system);
    }

    public static Job doTaskScheduled(IActionOperation runnable, ILoggedOperationFactory factory, boolean system) {
        final IActionOperation logged = factory == null ? runnable : factory.getLogged(runnable);
        Job job = new Job(logged.getOperationName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(this, logged){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IActionOperation val$logged;
                        {
                            this.this$1 = var1_1;
                            this.val$logged = iActionOperation;
                        }

                        public void run(IProgressMonitor monitor) throws CoreException {
                            ProgressMonitorUtility.doTaskExternal(this.val$logged, monitor, null);
                        }
                    }, this.getRule(), 1, monitor);
                }
                catch (CoreException e) {
                    LoggedOperation.reportError(SVNTeamPlugin.instance().getResource("Error.ScheduledTask"), e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(logged.getSchedulingRule());
        job.setSystem(system);
        job.schedule();
        return job;
    }

    public static void doTaskExternalDefault(IActionOperation runnable, IProgressMonitor monitor) {
        ProgressMonitorUtility.doTaskExternal(runnable, monitor, ILoggedOperationFactory.DEFAULT);
    }

    public static void doTaskExternal(IActionOperation runnable, IProgressMonitor monitor) {
        ProgressMonitorUtility.doTaskExternal(runnable, monitor, SVNTeamPlugin.instance().getOptionProvider().getLoggedOperationFactory());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void doTaskExternal(IActionOperation runnable, IProgressMonitor monitor, ILoggedOperationFactory factory) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(null, 100);
        try {
            ProgressMonitorUtility.doTask(factory == null ? runnable : factory.getLogged(runnable), monitor, 1);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void doTask(IActionOperation runnable, IProgressMonitor monitor, int subTasksCount) {
        if (subTasksCount > 0) {
            monitor = new SubProgressMonitorWithInfo((IProgressMonitor)monitor, 100 / subTasksCount);
        }
        monitor.beginTask(runnable.getOperationName(), 100);
        ProgressMonitorUtility.setTaskInfo(monitor, runnable, SVNTeamPlugin.instance().getResource("Progress.Running"));
        try {
            runnable.run((IProgressMonitor)monitor);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            ProgressMonitorUtility.setTaskInfo(monitor, runnable, SVNTeamPlugin.instance().getResource("Progress.Done"));
            monitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        ProgressMonitorUtility.setTaskInfo(monitor, runnable, SVNTeamPlugin.instance().getResource("Progress.Done"));
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void doSubTask(IActionOperation runnable, IUnprotectedOperation op, IProgressMonitor monitor, int subTasksCount) throws Exception {
        if (subTasksCount > 0) {
            monitor = new SubProgressMonitorWithInfo((IProgressMonitor)monitor, 100 / subTasksCount);
        }
        monitor.beginTask(runnable.getOperationName(), 100);
        try {
            op.run((IProgressMonitor)monitor);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    public static void progress(IProgressMonitor monitor, int current, int total) {
        if (monitor instanceof SubProgressMonitorWithInfo) {
            SubProgressMonitorWithInfo info = (SubProgressMonitorWithInfo)monitor;
            if (total != -1) {
                int real = 100 * current / total;
                info.worked(real -= info.getCurrentProgress());
            } else {
                info.unknownProgress(current);
            }
        } else {
            monitor.worked(1);
        }
    }

    public static void setTaskInfo(IProgressMonitor monitor, IActionOperation op, String subTask) {
        String message = SVNTeamPlugin.instance().getResource("Progress.SubTask");
        monitor.subTask(MessageFormat.format(message, op.getOperationName(), subTask == null || subTask.length() == 0 ? SVNTeamPlugin.instance().getResource("Progress.Running") : subTask));
    }

    private ProgressMonitorUtility() {
    }
}

