/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.utility;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.RepositoryProvider;
import org.polarion.team.svn.core.IConnectedProjectInformation;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.UnreportableException;
import org.polarion.team.svn.core.operation.local.GetAllResourcesOperation;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.PatternProvider;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public final class FileUtility {
    public static final IResource[] NO_CHILDREN = new IResource[0];
    public static final int COPY_NO_OPTIONS = 0;
    public static final int COPY_IGNORE_EXISTING_FOLDERS = 1;
    public static final int COPY_OVERRIDE_EXISTING_FILES = 2;
    static /* synthetic */ Class class$0;

    public static IResource selectOneOf(IResource[] scope, IResource[] set) {
        int i = 0;
        while (i < set.length) {
            if (FileUtility.relatesTo(scope, set[i])) {
                return set[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean relatesTo(IResource[] set, IResource resource) {
        int i = 0;
        while (i < set.length) {
            if (FileUtility.relatesTo(set[i], resource)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean relatesTo(IResource set, IResource resource) {
        return set.equals((Object)resource) ? true : (resource == null ? false : FileUtility.relatesTo(set, (IResource)resource.getParent()));
    }

    public static String getResource(ResourceBundle bundle, String key) {
        if (key == null) {
            return null;
        }
        if (bundle == null) {
            return key;
        }
        String retVal = FileUtility.getResourceImpl(bundle, key);
        if (retVal != null) {
            String id;
            if (key.indexOf("Error") != -1 && (id = FileUtility.getResourceImpl(bundle, String.valueOf(key) + ".Id")) != null) {
                retVal = String.valueOf(id) + ": " + retVal;
            }
            return retVal;
        }
        return key;
    }

    public static String getWorkingCopyPath(IResource resource) {
        return FileUtility.getResourcePath(resource).toString();
    }

    public static IPath getResourcePath(IResource resource) {
        IPath location = resource.getLocation();
        if (location == null) {
            String errMessage = SVNTeamPlugin.instance().getResource("Error.InaccessibleResource");
            throw new UnreportableException(MessageFormat.format(errMessage, resource.getFullPath().toString()));
        }
        return location;
    }

    public static Map getEnvironmentVariables() {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.System");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method getenv = clazz.getMethod("getenv", null);
            return (Map)getenv.invoke(null, null);
        }
        catch (Exception exception) {
            try {
                String varLine;
                boolean isWindows = FileUtility.isWindows();
                Process p = isWindows ? Runtime.getRuntime().exec("cmd.exe /c set") : Runtime.getRuntime().exec("env");
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                HashMap<String, String> retVal = new HashMap<String, String>();
                while ((varLine = br.readLine()) != null) {
                    int idx = varLine.indexOf(61);
                    if (idx != -1) {
                        String name = varLine.substring(0, idx);
                        retVal.put(isWindows ? name.toUpperCase() : name, varLine.substring(idx + 1));
                        continue;
                    }
                    if (varLine.length() <= 0) continue;
                    retVal.put(varLine, "");
                }
                return retVal;
            }
            catch (IOException iOException) {
                return Collections.EMPTY_MAP;
            }
        }
    }

    public static String normalizePath(String path) {
        return FileUtility.isWindows() ? path.replace('/', '\\') : path.replace('\\', '/');
    }

    public static boolean isWindows() {
        return FileUtility.getOSName().indexOf("windows") != -1;
    }

    public static String getOSName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static boolean isCaseInsensitiveOS() {
        return "macosx".equals(Platform.getOS()) || new File("a").compareTo(new File("A")) == 0;
    }

    public static boolean isLinked(IResource resource) {
        return resource.isLinked(512);
    }

    public static String[] asPathArray(IResource[] resources) {
        String[] retVal = new String[resources.length];
        int i = 0;
        while (i < resources.length) {
            retVal[i] = FileUtility.normalizePath(FileUtility.getWorkingCopyPath(resources[i]));
            ++i;
        }
        return retVal;
    }

    public static String[] asPathArray(File[] files) {
        String[] retVal = new String[files.length];
        int i = 0;
        while (i < files.length) {
            retVal[i] = FileUtility.normalizePath(files[i].getAbsolutePath());
            ++i;
        }
        return retVal;
    }

    public static String getResourceParent(IRepositoryResource resource) {
        String rootUrl;
        String parent = "";
        String url = resource.getUrl();
        if (url.equals(rootUrl = resource.getRoot().getUrl())) {
            return "";
        }
        parent = url.substring(rootUrl.length(), url.length() - resource.getName().length() - 1);
        return parent;
    }

    public static String formatResourceName(String projectName) {
        return PatternProvider.replaceAll(projectName, "([\\/:])+", ".");
    }

    public static String formatPath(String path) {
        return PatternProvider.replaceAll(path, "\\\\", "/");
    }

    public static String getUsernameParam(String username) {
        return username == null || username.trim().length() == 0 ? "" : " --username \"" + username + "\"";
    }

    public static String flattenText(String text) {
        StringBuffer flat = new StringBuffer(text.length() + 20);
        boolean skipAdjacentLineSeparator = true;
        int i = 0;
        while (i < text.length()) {
            char currentChar = text.charAt(i);
            if (currentChar == '\r' || currentChar == '\n') {
                if (!skipAdjacentLineSeparator) {
                    flat.append("/");
                }
                skipAdjacentLineSeparator = true;
            } else {
                flat.append(currentChar);
                skipAdjacentLineSeparator = false;
            }
            ++i;
        }
        return flat.toString().replace('\t', ' ');
    }

    public static int getMaxStringLength(String[] strings) {
        int result = 0;
        int i = 0;
        while (i < strings.length) {
            result = Math.max(result, strings[i].length());
            ++i;
        }
        return result;
    }

    public static String formatMultilineText(String text) {
        if (text.length() > 0 && text.substring(0, 1).matches("(\\s)+")) {
            text = text.replaceFirst("(\\s)+", "");
        }
        if (text.length() == 0) {
            return "";
        }
        text = text.replace('\t', ' ');
        int idx = text.indexOf(10);
        int idx1 = text.indexOf(13);
        if (idx == -1) {
            idx = idx1;
        }
        int n = idx = idx < idx1 || idx1 == -1 ? idx : idx1;
        if (idx != -1) {
            if (text.substring(idx).trim().length() != 0) {
                return String.valueOf(text.substring(0, idx)) + "...";
            }
            return text.substring(0, idx);
        }
        return text;
    }

    public static String[] decodeStringToArray(String encodedString) {
        String[] valuesArray = new String[]{};
        if (encodedString != null && encodedString.length() > 0) {
            valuesArray = encodedString.split(";");
            int i = 0;
            while (i < valuesArray.length) {
                valuesArray[i] = new String(Base64.decode((byte[])valuesArray[i].getBytes()));
                ++i;
            }
        }
        return valuesArray;
    }

    public static String encodeArrayToString(String[] valuesArray) {
        String result = "";
        int i = 0;
        while (i < valuesArray.length) {
            String str = new String(Base64.encode((byte[])valuesArray[i].getBytes()));
            result = String.valueOf(result) + (result.length() == 0 ? str : ";" + str);
            ++i;
        }
        return result;
    }

    public static void visitNodes(IResource resource, IResourceVisitor visitor, int depth) throws CoreException {
        boolean stepInside = visitor.visit(resource);
        if (stepInside && resource instanceof IContainer && depth != 0 && resource.isAccessible()) {
            IContainer container = (IContainer)resource;
            IResource[] children = FileUtility.resourceMembers(container, true);
            int nextDepth = depth == 1 ? 0 : depth;
            int i = 0;
            while (i < children.length) {
                FileUtility.visitNodes(children[i], visitor, nextDepth);
                ++i;
            }
        }
    }

    public static boolean checkForResourcesPresenceRecursive(IResource[] roots, IStateFilter filter) {
        return FileUtility.checkForResourcesPresence(roots, filter, 2);
    }

    public static boolean checkForResourcesPresence(IResource[] roots, IStateFilter filter, int depth) {
        ILocalResource local;
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        ArrayList<IResource> recursiveCheck = null;
        int nextDepth = 0;
        if (depth != 0) {
            recursiveCheck = new ArrayList<IResource>();
            nextDepth = depth == 1 ? 0 : 2;
        }
        int i = 0;
        while (i < roots.length) {
            if (!roots[i].isTeamPrivateMember() && (local = storage.asLocalResource(roots[i])) != null) {
                if (filter.accept(roots[i], local.getStatus(), local.getChangeMask())) {
                    return true;
                }
                if (roots[i] instanceof IContainer && depth != 0 && filter.allowsRecursion(roots[i], local.getStatus(), local.getChangeMask())) {
                    recursiveCheck.add(roots[i]);
                }
            }
            ++i;
        }
        if (depth != 0) {
            Iterator it = recursiveCheck.iterator();
            while (it.hasNext()) {
                local = (IContainer)it.next();
                if (!FileUtility.checkForResourcesPresence(FileUtility.getAllMembers((IContainer)local), filter, nextDepth)) continue;
                return true;
            }
        }
        return false;
    }

    public static IResource[] getResourcesRecursive(IResource[] roots, IStateFilter filter) {
        return FileUtility.getResourcesRecursive(roots, filter, 2);
    }

    public static IResource[] getResourcesRecursive(IResource[] roots, IStateFilter filter, int depth) {
        return FileUtility.getResourcesRecursive(roots, filter, depth, null, null);
    }

    public static IResource[] getResourcesRecursive(IResource[] roots, IStateFilter filter, int depth, IActionOperation calledFrom, IProgressMonitor monitor) {
        HashSet resources = new HashSet();
        FileUtility.addChildren(resources, roots, filter, depth, calledFrom, monitor);
        return resources.toArray(new IResource[resources.size()]);
    }

    public static IResource[] addOperableParents(IResource[] resources, IStateFilter stateFilter) {
        return FileUtility.addOperableParents(resources, stateFilter, false);
    }

    public static IResource[] addOperableParents(IResource[] resources, IStateFilter stateFilter, boolean through) {
        HashSet<IResource> tmp = new HashSet<IResource>(Arrays.asList(resources));
        tmp.addAll(Arrays.asList(FileUtility.getOperableParents(resources, stateFilter, through)));
        return tmp.toArray(new IResource[tmp.size()]);
    }

    public static IResource[] getOperableParents(IResource[] resources, IStateFilter stateFilter) {
        return FileUtility.getOperableParents(resources, stateFilter, false);
    }

    public static IResource[] getOperableParents(IResource[] resources, IStateFilter stateFilter, boolean through) {
        HashSet<IResource> tmp = new HashSet<IResource>();
        IResource[] parents = FileUtility.getParents(resources, true);
        if (!through) {
            FileUtility.reorder(parents, false);
        }
        int i = 0;
        while (i < parents.length) {
            ILocalResource parent = SVNRemoteStorage.instance().asLocalResource(parents[i]);
            if (parent != null && stateFilter.accept(parents[i], parent.getStatus(), parent.getChangeMask())) {
                tmp.add(parents[i]);
            } else if (!through) {
                IPath current = parents[i].getFullPath();
                while (i < parents.length) {
                    if (parents[i].getFullPath().isPrefixOf(current)) {
                        ++i;
                        continue;
                    }
                    --i;
                    break;
                }
            }
            ++i;
        }
        return tmp.toArray(new IResource[tmp.size()]);
    }

    public static IResource[] getParents(IResource[] resources, boolean excludeIncoming) {
        HashSet<IResource> parents = new HashSet<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource parent = resources[i];
            while ((parent = parent.getParent()) != null && !(parent instanceof IWorkspaceRoot)) {
                parents.add(parent);
            }
            if (parents == resources[i]) {
                parents.add(parent);
            }
            ++i;
        }
        if (excludeIncoming) {
            parents.removeAll(Arrays.asList(resources));
        }
        return parents.toArray(new IResource[parents.size()]);
    }

    public static boolean isSVNInternals(IResource resource) {
        if (SVNUtility.getSVNFolderName().equals(resource.getName())) {
            return true;
        }
        IContainer parent = resource.getParent();
        return parent == null ? false : FileUtility.isSVNInternals((IResource)parent);
    }

    public static void findAndMarkSVNInternals(IResource node, boolean isTeamPrivate) throws CoreException {
        if (node instanceof IContainer && !FileUtility.isLinked(node)) {
            if (SVNUtility.getSVNFolderName().equals(node.getName()) && node.isTeamPrivateMember() != isTeamPrivate) {
                FileUtility.markSVNInternalsTree(node, isTeamPrivate);
            } else {
                IResource[] children = FileUtility.resourceMembers((IContainer)node, false);
                int i = 0;
                while (i < children.length) {
                    FileUtility.findAndMarkSVNInternals(children[i], isTeamPrivate);
                    ++i;
                }
            }
        }
    }

    public static boolean deleteRecursive(File node) {
        return FileUtility.deleteRecursive(node, null);
    }

    public static boolean deleteRecursive(File node, IProgressMonitor monitor) {
        File[] files;
        if (node.isDirectory() && (files = node.listFiles()) != null) {
            int i = 0;
            while (!(i >= files.length || monitor != null && monitor.isCanceled())) {
                FileUtility.deleteRecursive(files[i], monitor);
                ++i;
            }
        }
        return node.delete();
    }

    public static void copyAll(File to, File what, IProgressMonitor monitor) throws Exception {
        FileUtility.copyAll(to, what, false, monitor);
    }

    public static void copyAll(File to, File what, boolean ignoreExistingFolders, IProgressMonitor monitor) throws Exception {
        FileUtility.copyAll(to, what, ignoreExistingFolders ? 1 : 0, null, monitor);
    }

    public static void copyAll(File to, File what, int options, FileFilter filter, IProgressMonitor monitor) throws Exception {
        if (what.isDirectory()) {
            to = new File(String.valueOf(to.getAbsolutePath()) + "/" + what.getName());
            if (monitor.isCanceled()) {
                return;
            }
            if (!to.mkdirs() && (options & 1) == 0) {
                String errMessage = SVNTeamPlugin.instance().getResource("Error.CreateDirectory");
                throw new Exception(MessageFormat.format(errMessage, to.getAbsolutePath()));
            }
            File[] files = what.listFiles(filter);
            if (files != null) {
                int i = 0;
                while (i < files.length && !monitor.isCanceled()) {
                    FileUtility.copyAll(to, files[i], options, filter, monitor);
                    ++i;
                }
            }
        } else {
            FileUtility.copyFile(to, what, options, monitor);
        }
    }

    public static void copyFile(File to, File what, IProgressMonitor monitor) throws Exception {
        FileUtility.copyFile(to, what, 2, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(File to, File what, int options, IProgressMonitor monitor) throws Exception {
        FileInputStream input;
        block14: {
            if (to.exists() && to.isDirectory()) {
                to = new File(String.valueOf(to.getAbsolutePath()) + "/" + what.getName());
            }
            if (to.exists()) {
                if ((options & 2) == 0) return;
            }
            if (monitor.isCanceled()) return;
            FileOutputStream output = null;
            input = null;
            try {
                output = new FileOutputStream(to);
                input = new FileInputStream(what);
                byte[] buf = new byte[2048];
                int loaded = 0;
                while ((loaded = input.read(buf)) > 0 && !monitor.isCanceled()) {
                    output.write(buf, 0, loaded);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (Exception exception) {}
                }
                if (input == null) throw throwable;
                try {
                    input.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var8_10 = null;
                if (output == null) break block14;
            }
            try {}
            catch (Exception exception) {}
            output.close();
        }
        if (input == null) return;
        try {}
        catch (Exception exception) {
            return;
        }
        input.close();
    }

    public static void removeSVNMetaInformation(IResource root, IProgressMonitor monitor) throws CoreException {
        final ArrayList toRemove = new ArrayList();
        root.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (SVNUtility.getSVNFolderName().equals(resource.getName()) && !FileUtility.isLinked(resource)) {
                    toRemove.add(resource);
                    return false;
                }
                return true;
            }
        }, 2, 3);
        Iterator it = toRemove.iterator();
        while (it.hasNext()) {
            IResource resource = (IResource)it.next();
            FileUtility.deleteRecursive(new File(resource.getLocation().toString()));
        }
    }

    public static boolean alreadyOnSVN(IResource root) {
        return SVNUtility.getSVNInfoForNotConnected(root) != null;
    }

    public static boolean isConnected(IResource resource) {
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject());
        return provider != null && provider instanceof IConnectedProjectInformation;
    }

    public static IResource[] getPathNodes(IResource resource) {
        return FileUtility.getPathNodes(new IResource[]{resource});
    }

    public static IResource[] getPathNodes(IResource[] resources) {
        List<IResource> tmp = Arrays.asList(resources);
        HashSet<IResource> modifiedRoots = new HashSet<IResource>();
        IWorkspaceRoot wRoot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < resources.length) {
            IResource root = resources[i];
            while ((root = root.getParent()) != wRoot) {
                if (tmp.contains(root)) break;
                modifiedRoots.add(root);
            }
            ++i;
        }
        return modifiedRoots.toArray(new IResource[modifiedRoots.size()]);
    }

    public static void reorder(IResource[] resources, final boolean parent2Child) {
        FileUtility.sort(resources, new Comparator(){

            public int compare(Object o1, Object o2) {
                String first = ((IResource)o1).getFullPath().toString();
                String second = ((IResource)o2).getFullPath().toString();
                return parent2Child ? first.compareTo(second) : second.compareTo(first);
            }
        });
    }

    public static void reorder(File[] files, final boolean parent2Child) {
        FileUtility.sort(files, new Comparator(){

            public int compare(Object o1, Object o2) {
                String first = ((File)o1).getAbsolutePath();
                String second = ((File)o2).getAbsolutePath();
                return parent2Child ? first.compareTo(second) : second.compareTo(first);
            }
        });
    }

    public static IResource[] shrinkChildNodes(IResource[] resources) {
        HashSet<IResource> tRoots = new HashSet<IResource>(Arrays.asList(resources));
        int i = 0;
        while (i < resources.length) {
            if (FileUtility.hasRoots(tRoots, resources[i])) {
                tRoots.remove(resources[i]);
            }
            ++i;
        }
        return tRoots.toArray(new IResource[tRoots.size()]);
    }

    public static File[] shrinkChildNodes(File[] files, boolean skipFiles) {
        HashSet<File> tRoots = new HashSet<File>(Arrays.asList(files));
        int i = 0;
        while (i < files.length) {
            if (!(skipFiles && files[i].isFile() || !FileUtility.hasRoots(tRoots, files[i]))) {
                tRoots.remove(files[i]);
            }
            ++i;
        }
        return tRoots.toArray(new File[tRoots.size()]);
    }

    public static IResource[] resourceMembers(IContainer node, boolean includePhantoms) throws CoreException {
        try {
            return node.members(includePhantoms);
        }
        catch (CoreException ex) {
            if (node.isAccessible()) {
                throw ex;
            }
            return new IResource[0];
        }
    }

    public static String getNamesListAsString(Object[] resources) {
        String resourcesNames = "";
        String name = "";
        int i = 0;
        while (i < resources.length) {
            if (i == 4) {
                resourcesNames = String.valueOf(resourcesNames) + "...";
                break;
            }
            name = resources[i] instanceof IRepositoryResource ? ((IRepositoryResource)resources[i]).getName() : (resources[i] instanceof IResource ? ((IResource)resources[i]).getName() : resources[i].toString());
            resourcesNames = String.valueOf(resourcesNames) + (i == 0 ? "'" : ", '") + name + "'";
            ++i;
        }
        return resourcesNames;
    }

    public static void sort(Object[] array) {
        Arrays.sort(array);
    }

    public static void sort(Object[] array, Comparator cmp) {
        Arrays.sort(array, cmp);
    }

    public static boolean hasNature(IResource resource, String natureId) throws CoreException {
        IProject project = resource.getProject();
        if (project == null) {
            return false;
        }
        String[] natureIds = project.getDescription().getNatureIds();
        int i = 0;
        while (i < natureIds.length) {
            if (natureId.equals(natureIds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasRoots(Set roots, IResource node) {
        while ((node = node.getParent()) != null) {
            if (!roots.contains(node)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasRoots(Set roots, File node) {
        while ((node = node.getParentFile()) != null) {
            if (!roots.contains(node)) continue;
            return true;
        }
        return false;
    }

    private static void markSVNInternalsTree(IResource node, boolean isTeamPrivate) throws CoreException {
        if (node instanceof IContainer) {
            IResource[] children = FileUtility.resourceMembers((IContainer)node, false);
            int i = 0;
            while (i < children.length) {
                FileUtility.markSVNInternalsTree(children[i], isTeamPrivate);
                ++i;
            }
        }
        node.setTeamPrivateMember(isTeamPrivate);
    }

    private static void addChildren(Set resources, IResource[] roots, IStateFilter filter, int depth, IActionOperation calledFrom, IProgressMonitor monitor) {
        int nextDepth = depth == 1 ? 0 : 2;
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        int i = 0;
        while (!(i >= roots.length || monitor != null && monitor.isCanceled())) {
            if (!roots[i].isTeamPrivateMember()) {
                ILocalResource local;
                if (monitor != null) {
                    String path = roots[i].getFullPath().toString();
                    if (calledFrom != null) {
                        ProgressMonitorUtility.setTaskInfo(monitor, calledFrom, path);
                    } else {
                        monitor.subTask(path);
                    }
                    ProgressMonitorUtility.progress(monitor, 1, -1);
                }
                if ((local = storage.asLocalResource(roots[i])) != null) {
                    if (filter.accept(roots[i], local.getStatus(), local.getChangeMask())) {
                        resources.add(roots[i]);
                    }
                    if (roots[i] instanceof IContainer && depth != 0 && filter.allowsRecursion(roots[i], local.getStatus(), local.getChangeMask())) {
                        FileUtility.addChildren(resources, FileUtility.getAllMembers((IContainer)roots[i]), filter, nextDepth, calledFrom, monitor);
                    }
                }
            }
            ++i;
        }
    }

    private static IResource[] getAllMembers(IContainer root) {
        GetAllResourcesOperation op = new GetAllResourcesOperation(root);
        ProgressMonitorUtility.doTaskExternalDefault(op, (IProgressMonitor)new NullProgressMonitor());
        return op.getChildren();
    }

    private static String getResourceImpl(ResourceBundle bundle, String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private FileUtility() {
    }
}

