/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.svnstorage;

import java.io.Serializable;
import org.polarion.team.svn.core.client.ClientWrapperCancelException;
import org.polarion.team.svn.core.client.ClientWrapperException;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.resource.IRepositoryContainer;
import org.polarion.team.svn.core.resource.IRepositoryFile;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryRoot;
import org.polarion.team.svn.core.resource.ISVNStorage;
import org.polarion.team.svn.core.svnstorage.SVNRepositoryBase;

public abstract class SVNRepositoryResource
extends SVNRepositoryBase
implements IRepositoryResource,
Serializable {
    private static final long serialVersionUID = 8854704746872311777L;
    private transient Revision selectedRevision;
    private transient Revision pegRevision;
    protected transient Revision.Number lastRevision;
    protected transient IRepositoryLocation location;
    protected transient IRepositoryRoot root;
    protected transient IRepositoryResource.Info info;

    protected SVNRepositoryResource() {
    }

    public SVNRepositoryResource(IRepositoryLocation location, String url, Revision selectedRevision) {
        super(url);
        this.location = location;
        this.selectedRevision = selectedRevision;
    }

    public void setInfo(IRepositoryResource.Info info) {
        this.info = info;
    }

    public IRepositoryResource.Info getInfo() {
        return this.info;
    }

    public Revision getPegRevision() {
        return this.pegRevision == null ? Revision.HEAD : this.pegRevision;
    }

    public void setPegRevision(Revision pegRevision) {
        this.pegRevision = pegRevision;
    }

    public Revision getSelectedRevision() {
        if (this.selectedRevision == null) {
            this.selectedRevision = Revision.HEAD;
        }
        return this.selectedRevision;
    }

    public void setSelectedRevision(Revision revision) {
        this.selectedRevision = revision;
    }

    public boolean isInfoCached() {
        return this.lastRevision != null;
    }

    public synchronized void refresh() {
        this.lastRevision = null;
    }

    public void setRevision(long revisionNumber) {
        this.lastRevision = new Revision.Number(revisionNumber);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized long getRevision() throws ClientWrapperException {
        if (this.lastRevision != null) return this.lastRevision.getNumber();
        this.lastRevision = new ISVNStorage.InvalidRevision();
        ISVNClientWrapper proxy = this.getRepositoryLocation().acquireSVNProxy();
        try {
            this.getRevisionImpl(proxy);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.getRepositoryLocation().releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.getRepositoryLocation().releaseSVNProxy(proxy);
            return this.lastRevision.getNumber();
        }
    }

    public boolean exists() throws ClientWrapperException {
        try {
            return this.getRevision() != -1L;
        }
        catch (ClientWrapperException ex) {
            if (ex instanceof ClientWrapperCancelException) {
                throw ex;
            }
            return false;
        }
    }

    public IRepositoryResource getParent() {
        String parentUrl = this.getUrl();
        int idx = parentUrl.lastIndexOf(47);
        if (idx != -1) {
            parentUrl = parentUrl.substring(0, idx);
        }
        return this.asRepositoryContainer(parentUrl, true);
    }

    public synchronized IRepositoryResource getRoot() {
        if (this.root == null) {
            IRepositoryResource parent = this;
            while (!(parent instanceof IRepositoryRoot)) {
                parent = parent.getParent();
            }
            this.root = (IRepositoryRoot)parent;
        }
        return this.root;
    }

    public IRepositoryLocation getRepositoryLocation() {
        return this.location;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IRepositoryResource)) {
            return false;
        }
        IRepositoryResource other = (IRepositoryResource)obj;
        return super.equals(obj) && this.getSelectedRevision().equals(other.getSelectedRevision()) && this.getPegRevision().equals(other.getPegRevision());
    }

    public IRepositoryContainer asRepositoryContainer(String url, boolean allowsNull) {
        IRepositoryContainer retVal = this.getRepositoryLocation().asRepositoryContainer(url.indexOf(47) != -1 ? url : String.valueOf(this.getUrl()) + "/" + url, allowsNull);
        if (retVal == null) {
            return null;
        }
        retVal.setPegRevision(this.getPegRevision());
        retVal.setSelectedRevision(this.getSelectedRevision());
        return retVal;
    }

    public IRepositoryFile asRepositoryFile(String url, boolean allowsNull) {
        IRepositoryFile retVal = this.getRepositoryLocation().asRepositoryFile(url.indexOf(47) != -1 ? url : String.valueOf(this.getUrl()) + "/" + url, allowsNull);
        if (retVal == null) {
            return null;
        }
        retVal.setPegRevision(this.getPegRevision());
        retVal.setSelectedRevision(this.getSelectedRevision());
        return retVal;
    }

    protected abstract void getRevisionImpl(ISVNClientWrapper var1) throws ClientWrapperException;
}

