/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.svnstorage;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.RepositoryProvider;
import org.polarion.team.svn.core.IConnectedProjectInformation;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.ClientWrapperCancelException;
import org.polarion.team.svn.core.client.ClientWrapperException;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.extension.CoreExtensionsManager;
import org.polarion.team.svn.core.extension.options.IIgnoreRecommendations;
import org.polarion.team.svn.core.operation.AbstractActionOperation;
import org.polarion.team.svn.core.operation.SVNNullProgressMonitor;
import org.polarion.team.svn.core.operation.UnreportableException;
import org.polarion.team.svn.core.resource.IChangeStateProvider;
import org.polarion.team.svn.core.resource.ILocalFolder;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRemoteStorage;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IResourceChange;
import org.polarion.team.svn.core.resource.ISVNStorage;
import org.polarion.team.svn.core.resource.events.IResourceStatesListener;
import org.polarion.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.polarion.team.svn.core.svnstorage.AbstractSVNStorage;
import org.polarion.team.svn.core.svnstorage.SVNFileChange;
import org.polarion.team.svn.core.svnstorage.SVNFolderChange;
import org.polarion.team.svn.core.svnstorage.SVNLocalFile;
import org.polarion.team.svn.core.svnstorage.SVNLocalFolder;
import org.polarion.team.svn.core.svnstorage.SVNLocalResource;
import org.polarion.team.svn.core.svnstorage.SVNRepositoryLocationWrapper;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class SVNRemoteStorage
extends AbstractSVNStorage
implements IRemoteStorage {
    public static final String STATE_INFO_FILE_NAME = ".svnRepositories";
    private static SVNRemoteStorage instance = new SVNRemoteStorage();
    protected Map localResources = Collections.synchronizedMap(new HashMap());
    protected Map switchedToUrls = Collections.synchronizedMap(new LinkedHashMap());
    protected Map externalsLocations;
    protected Map parent2Children = new HashMap();
    protected Map resourceStateListeners;
    protected LinkedList fetchQueue;
    private static final IStateFilter SF_NONSVN = new IStateFilter(){

        public boolean accept(IResource resource, String state, int mask) {
            return state == "Prereplaced" || state == "New" || state == "None" || state == IStateFilter.ST_NOTEXISTS || state == "Linked" || state == "Obstructed";
        }

        public boolean allowsRecursion(IResource resource, String state, int mask) {
            return true;
        }
    };

    public static SVNRemoteStorage instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceStatesListener(Class eventClass, IResourceStatesListener listener) {
        Map map = this.resourceStateListeners;
        synchronized (map) {
            ArrayList<IResourceStatesListener> listenersList = (ArrayList<IResourceStatesListener>)this.resourceStateListeners.get(eventClass);
            if (listenersList == null) {
                listenersList = new ArrayList<IResourceStatesListener>();
                this.resourceStateListeners.put(eventClass, listenersList);
            }
            if (!listenersList.contains(listener)) {
                listenersList.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceStatesListener(Class eventClass, IResourceStatesListener listener) {
        Map map = this.resourceStateListeners;
        synchronized (map) {
            List listenersList = (List)this.resourceStateListeners.get(eventClass);
            if (listenersList != null) {
                listenersList.remove(listener);
                if (listenersList.size() == 0) {
                    this.resourceStateListeners.remove(eventClass);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireResourceStatesChangedEvent(ResourceStatesChangedEvent event) {
        IResourceStatesListener[] listeners = null;
        Map map = this.resourceStateListeners;
        synchronized (map) {
            List listenersArray = (List)this.resourceStateListeners.get(event.getClass());
            if (listenersArray == null) {
                return;
            }
            listeners = listenersArray.toArray(new IResourceStatesListener[listenersArray.size()]);
        }
        int i = 0;
        while (i < listeners.length) {
            listeners[i].resourcesStateChanged(event);
            ++i;
        }
    }

    public void initialize(IPath stateInfoLocation) throws Exception {
        this.initializeImpl(stateInfoLocation, STATE_INFO_FILE_NAME);
    }

    public IResourceChange asResourceChange(IChangeStateProvider changeState) {
        String statusStr;
        IResource resource = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path location = new Path(changeState.getLocalPath());
        int nodeKind = changeState.getNodeKind();
        int propKind = changeState.getPropertiesChangeType();
        int textKind = changeState.getTextChangeType();
        boolean isCopied = changeState.isCopied();
        boolean isSwitched = changeState.isSwitched();
        Revision.Number remoteRevision = changeState.getChangeRevision();
        long revision = remoteRevision != null ? remoteRevision.getNumber() : -1L;
        String string = statusStr = revision == -1L ? IStateFilter.ST_NOTEXISTS : this.getStatusString(propKind, textKind, true);
        if (nodeKind == 2) {
            resource = changeState.getExact((IResource[])root.findContainersForLocation((IPath)location));
            if (resource == null) {
                return null;
            }
            int changeMask = this.getChangeMask(textKind, propKind, isCopied, isSwitched);
            if (IStateFilter.SF_NOTEXISTS.accept(resource, statusStr, changeMask)) {
                revision = -1L;
            }
            return new SVNFolderChange(resource, revision, statusStr, changeMask, changeState.getChangeAuthor(), changeState.getChangeDate(), null, changeState.getComment());
        }
        resource = changeState.getExact((IResource[])root.findFilesForLocation((IPath)location));
        if (resource == null) {
            return null;
        }
        int changeMask = this.getChangeMask(textKind, propKind, isCopied, isSwitched);
        if (IStateFilter.SF_NOTEXISTS.accept(resource, statusStr, changeMask)) {
            revision = -1L;
        }
        return new SVNFileChange(resource, revision, statusStr, changeMask, changeState.getChangeAuthor(), changeState.getChangeDate(), null, changeState.getComment());
    }

    public byte[] resourceChangeAsBytes(IResourceChange resource) {
        if (resource == null) {
            return null;
        }
        int kind = resource.getPegRevision().getKind();
        String originatorData = null;
        if (resource.getOriginator() != null) {
            byte[] data = this.repositoryResourceAsBytes(resource.getOriginator());
            originatorData = new String(Base64.encode((byte[])data));
        }
        long lastCommitDate = resource.getLastCommitDate();
        String comment = resource.getComment();
        String retVal = String.valueOf(String.valueOf(resource instanceof ILocalFolder)) + ";" + new String(Base64.encode((byte[])FileUtility.getWorkingCopyPath(resource.getResource()).getBytes())) + ";" + resource.getRevision() + ";" + resource.getStatus() + ";" + resource.getAuthor() + ";" + (lastCommitDate == 0L ? "null" : String.valueOf(lastCommitDate)) + ";" + String.valueOf(kind) + ";" + (kind == 1 ? String.valueOf(((Revision.Number)resource.getPegRevision()).getNumber()) : String.valueOf(kind)) + ";" + (originatorData != null ? originatorData : "null") + ";" + (comment == null ? "null" : new String(Base64.encode((byte[])comment.getBytes()))) + ";" + resource.getChangeMask();
        return retVal.getBytes();
    }

    public IResourceChange resourceChangeFromBytes(byte[] bytes) {
        SVNLocalResource change;
        long pegNum;
        if (bytes == null) {
            return null;
        }
        String[] data = new String(bytes).split(";");
        boolean isFolder = "true".equals(data[0]);
        String name = new String(Base64.decode((byte[])data[1].getBytes()));
        long revision = Long.parseLong(data[2]);
        String status = this.deserializeStatus(data[3]);
        String author = "null".equals(data[4]) ? null : data[4];
        long lastCommitDate = "null".equals(data[5]) ? 0L : Long.parseLong(data[5]);
        int revisionKind = Integer.parseInt(data[6]);
        Revision pegRevision = null;
        pegRevision = revisionKind == 1 ? ((pegNum = Long.parseLong(data[7])) == revision ? null : Revision.getInstance(pegNum)) : new ISVNStorage.KindBasedRevision(revisionKind);
        String comment = "null".equals(data[9]) ? null : new String(Base64.decode((byte[])data[9].getBytes()));
        int changeMask = "null".equals(data[10]) ? 0 : Integer.parseInt(data[10]);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        SVNLocalResource sVNLocalResource = change = isFolder ? new SVNFolderChange((IResource)root.getContainerForLocation((IPath)new Path(name)), revision, status, changeMask, author, lastCommitDate, pegRevision, comment) : new SVNFileChange((IResource)root.getFileForLocation((IPath)new Path(name)), revision, status, changeMask, author, lastCommitDate, pegRevision, comment);
        if (!"null".equals(data[8])) {
            byte[] originatorData = Base64.decode((byte[])data[8].getBytes());
            change.setOriginator(this.repositoryResourceFromBytes(originatorData));
        }
        return change;
    }

    public synchronized IResource[] getRegisteredChildren(IContainer container) throws Exception {
        ILocalResource local;
        if (container == null || !container.isAccessible() || container.getProject() == null) {
            return null;
        }
        IResource[] members = FileUtility.resourceMembers(container, false);
        Set<Object> retVal = (HashSet<IResource>)this.parent2Children.get(container.getFullPath());
        if (!(retVal != null || (local = this.asLocalResource((IResource)container)) != null && SF_NONSVN.accept((IResource)container, local.getStatus(), local.getChangeMask()))) {
            this.loadLocalResourcesSubTree((IResource)container, !CoreExtensionsManager.instance().getOptionProvider().isSVNCacheEnabled());
            retVal = (Set)this.parent2Children.get(container.getFullPath());
        }
        if (retVal != null) {
            retVal = new HashSet<IResource>(retVal);
            retVal.addAll(Arrays.asList(members));
        }
        return retVal == null ? members : retVal.toArray(new IResource[retVal.size()]);
    }

    public ILocalResource asLocalResourceDirty(IResource resource) {
        if (!CoreExtensionsManager.instance().getOptionProvider().isSVNCacheEnabled()) {
            return this.asLocalResource(resource);
        }
        if (resource == null || resource.getProject() == null) {
            return null;
        }
        ILocalResource retVal = (ILocalResource)this.localResources.get(resource.getFullPath());
        if (retVal == null) {
            ILocalResource parent = this.getFirstExistingParentLocal(resource);
            int mask = parent == null ? 0 : parent.getChangeMask() & 8;
            retVal = resource.getType() == 1 ? new SVNLocalFile(resource, -1L, IStateFilter.ST_NOTEXISTS, mask, null, -1L) : new SVNLocalFolder(resource, -1L, IStateFilter.ST_NOTEXISTS, mask, null, -1L);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ILocalResource asLocalResource(IResource resource) {
        if (resource == null) return null;
        if (resource.getProject() == null) {
            return null;
        }
        ILocalResource local = (ILocalResource)this.localResources.get(resource.getFullPath());
        if (local != null) return local;
        SVNRemoteStorage sVNRemoteStorage = this;
        synchronized (sVNRemoteStorage) {
            local = (ILocalResource)this.localResources.get(resource.getFullPath());
            if (local != null) return local;
            if (!resource.getProject().isAccessible()) return local;
            try {
                return this.loadLocalResourcesSubTree(resource, !CoreExtensionsManager.instance().getOptionProvider().isSVNCacheEnabled());
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (ClientWrapperCancelException clientWrapperCancelException) {
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public synchronized void refreshLocalResources(IResource[] resources, int depth) {
        if (depth == 2) {
            resources = FileUtility.shrinkChildNodes(resources);
        }
        int i = 0;
        while (i < resources.length) {
            this.refreshLocalResourceImpl(resources[i], depth);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILocalResource asLocalResource(IProject project, String url, int kind) {
        Map map = this.switchedToUrls;
        synchronized (map) {
            Iterator it = this.switchedToUrls.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String cachedUrl = (String)entry.getValue();
                if (!url.startsWith(cachedUrl)) continue;
                IPath target = ((IPath)entry.getKey()).append(url.substring(cachedUrl.length())).removeFirstSegments(1);
                return this.asLocalResource((IResource)(kind == 2 ? project.getFolder(target) : project.getFile(target)));
            }
        }
        String projectUrl = this.asRepositoryResource((IResource)project).getUrl();
        if (url.length() < projectUrl.length()) {
            return null;
        }
        String pathInProject = url.substring(projectUrl.length());
        if (pathInProject.length() == 0) {
            return this.asLocalResource((IResource)project);
        }
        return this.asLocalResource((IResource)(kind == 2 ? project.getFolder(pathInProject) : project.getFile(pathInProject)));
    }

    public IRepositoryResource asRepositoryResource(IResource resource) {
        ILocalResource parent;
        IProject project = resource.getProject();
        IRepositoryResource baseResource = this.getConnectedProjectInformation(project).getRepositoryResource();
        if (resource.equals((Object)project)) {
            return SVNUtility.copyOf(baseResource);
        }
        IRepositoryLocation location = baseResource.getRepositoryLocation();
        String url = (String)this.switchedToUrls.get(resource.getFullPath());
        if (url == null && (parent = this.getFirstExistingParentLocal(resource)) != null && (parent.getChangeMask() & 8) != 0) {
            IPath parentPath = parent.getResource().getFullPath();
            url = String.valueOf((String)this.switchedToUrls.get(parentPath)) + "/" + resource.getFullPath().removeFirstSegments(parentPath.segmentCount()).toString();
        }
        if (url == null) {
            url = this.makeUrl(resource, baseResource);
        } else if (!new Path(location.getRepositoryRootUrl()).isPrefixOf((IPath)new Path(url))) {
            location = this.wrapLocationIfRequired(location, url, resource.getType() == 1);
        }
        return resource instanceof IContainer ? location.asRepositoryContainer(url, false) : location.asRepositoryFile(url, false);
    }

    public IRepositoryResource asRepositoryResource(IRepositoryLocation location, String url, boolean isFile) {
        if (!new Path(location.getRepositoryRootUrl()).isPrefixOf((IPath)new Path(url))) {
            location = this.wrapLocationIfRequired(location, url, isFile);
        }
        return !isFile ? location.asRepositoryContainer(url, false) : location.asRepositoryFile(url, false);
    }

    public IRepositoryLocation getRepositoryLocation(IResource resource) {
        return this.getConnectedProjectInformation(resource.getProject()).getRepositoryLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRepositoryLocation wrapLocationIfRequired(IRepositoryLocation location, String url, boolean isFile) {
        if (!new Path(location.getRepositoryRootUrl()).isPrefixOf((IPath)new Path(url))) {
            Map map = this.externalsLocations;
            synchronized (map) {
                ArrayList<IRepositoryLocation> locations = (ArrayList<IRepositoryLocation>)this.externalsLocations.get(location);
                if (locations == null) {
                    locations = new ArrayList<IRepositoryLocation>();
                    this.externalsLocations.put(location, locations);
                }
                boolean found = false;
                Iterator it = locations.iterator();
                while (it.hasNext()) {
                    IRepositoryLocation tmp = (IRepositoryLocation)it.next();
                    if (!url.startsWith(tmp.getUrl()) && !tmp.getUrl().startsWith(url)) continue;
                    location = tmp;
                    found = true;
                    break;
                }
                if (!found) {
                    location = new SVNRepositoryLocationWrapper(location, isFile ? url.substring(0, url.lastIndexOf(47)) : url);
                    locations.add(location);
                }
            }
        }
        return location;
    }

    protected String makeUrl(IResource resource, IRepositoryResource baseResource) {
        if (resource.getType() == 4) {
            return baseResource.getUrl();
        }
        IProject project = resource.getProject();
        String url = resource.getFullPath().toString();
        return String.valueOf(baseResource.getUrl()) + "/" + url.substring(project.getFullPath().toString().length() + 1);
    }

    protected IConnectedProjectInformation getConnectedProjectInformation(IProject project) {
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
        if (provider == null) {
            String errMessage = SVNTeamPlugin.instance().getResource("Error.NotConnectedProject");
            throw new UnreportableException(MessageFormat.format(errMessage, project.getName()));
        }
        if (!(provider instanceof IConnectedProjectInformation)) {
            String errMessage = SVNTeamPlugin.instance().getResource("Error.AnotherProvider");
            throw new UnreportableException(MessageFormat.format(errMessage, project.getName(), provider.getID()));
        }
        return (IConnectedProjectInformation)provider;
    }

    protected void refreshLocalResourceImpl(IResource resource, int depth) {
        IConnectedProjectInformation info;
        ArrayList<IResource> removed = new ArrayList<IResource>();
        removed.add(resource);
        if (resource.getType() == 4 && (info = (IConnectedProjectInformation)RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"org.polarion.team.svn.core.svnnature")) != null) {
            try {
                info.relocateResource();
            }
            catch (CoreException ex) {
                throw new RuntimeException(ex);
            }
        }
        Iterator<Object> it = this.localResources.values().iterator();
        while (it.hasNext()) {
            int matchingSegmentsCount;
            int cachedSegmentsCount;
            int difference;
            ILocalResource local = (ILocalResource)it.next();
            IResource current = local.getResource();
            IPath currentPath = current.getFullPath();
            if (!resource.getFullPath().isPrefixOf(currentPath) && !IStateFilter.SF_NOTEXISTS.accept(current, local.getStatus(), local.getChangeMask()) || ((difference = (cachedSegmentsCount = currentPath.segmentCount()) - (matchingSegmentsCount = resource.getFullPath().matchingFirstSegments(currentPath))) < 0 || depth != 2) && depth < difference) continue;
            removed.add(current);
        }
        it = removed.iterator();
        while (it.hasNext()) {
            IResource forRemove = (IResource)it.next();
            this.localResources.remove(forRemove.getFullPath());
            this.switchedToUrls.remove(forRemove.getFullPath());
            this.parent2Children.remove(forRemove.getFullPath());
            this.parent2Children.remove(forRemove.getParent().getFullPath());
        }
    }

    protected ILocalResource loadLocalResourcesSubTree(IResource resource, boolean noCache) throws Exception {
        ILocalResource parentLocal;
        boolean parentExists;
        IConnectedProjectInformation provider = (IConnectedProjectInformation)RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"org.polarion.team.svn.core.svnnature");
        if (provider == null || FileUtility.isSVNInternals(resource)) {
            return null;
        }
        if (noCache) {
            this.localResources.clear();
        }
        ILocalResource retVal = null;
        boolean isLinked = FileUtility.isLinked(resource);
        IContainer parent = resource.getParent();
        boolean bl = parentExists = parent != null && parent.isAccessible();
        if (!(!parentExists || isLinked || (parentLocal = this.getFirstExistingParentLocal(resource)) != null && SF_NONSVN.accept(parentLocal.getResource(), parentLocal.getStatus(), parentLocal.getChangeMask()))) {
            retVal = this.loadLocalResourcesSubTreeSVNImpl(provider, resource, noCache);
        }
        return retVal == null ? this.loadUnversionedSubtree(resource, isLinked, noCache) : retVal;
    }

    protected ILocalResource loadUnversionedSubtree(final IResource resource, boolean isLinked, boolean noCache) throws CoreException {
        String status;
        final String fStatus = status = this.calculateUnversionedStatus(resource, isLinked);
        ILocalResource parent = this.getFirstExistingParentLocal(resource);
        final int parentCM = parent != null ? parent.getChangeMask() & 0x28 : 0;
        final ILocalResource[] tmp = new ILocalResource[1];
        FileUtility.visitNodes(resource, new IResourceVisitor(){

            public boolean visit(IResource child) throws CoreException {
                if (FileUtility.isSVNInternals(child)) {
                    return false;
                }
                String state = child == resource ? fStatus : SVNRemoteStorage.this.getDelegatedStatus(child, fStatus, 0);
                int changeMask = state == "Obstructed" || state == "New" ? 1 : 0;
                ILocalResource retVal = SVNRemoteStorage.this.registerResource(child, -1L, state, changeMask |= parentCM, null, -1L);
                if (tmp[0] == null) {
                    tmp[0] = retVal;
                }
                return true;
            }
        }, noCache ? 1 : 2);
        return tmp[0];
    }

    protected String calculateUnversionedStatus(IResource resource, boolean isLinked) {
        String status = IStateFilter.ST_NOTEXISTS;
        if (isLinked) {
            status = "Linked";
        } else {
            IPath location = resource.getLocation();
            if (location != null && this.isFileExists(location)) {
                status = "None";
                if (!SVNUtility.isIgnored(resource)) {
                    status = this.getTopLevelStatus(resource, "New", 0);
                }
            }
        }
        return status;
    }

    protected boolean isFileExists(IPath location) {
        if (new File(location.toString()).exists()) {
            if (FileUtility.isWindows()) {
                String[] names = new File(location.removeLastSegments(1).toString()).list();
                if (names != null) {
                    String name = location.lastSegment();
                    int i = 0;
                    while (i < names.length) {
                        if (names[i].equals(name)) {
                            return true;
                        }
                        ++i;
                    }
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected ILocalResource loadLocalResourcesSubTreeSVNImpl(IConnectedProjectInformation provider, IResource resource, boolean noCache) throws Exception {
        IProject project = resource.getProject();
        IResource target = null;
        boolean recursively = false;
        if (resource.getType() == 1) {
            target = resource.getParent();
        } else {
            target = resource;
            recursively = target.getFullPath().segmentCount() > 2 & !noCache;
        }
        IPath wcPath = project.getLocation();
        IPath resourcePath = target.getLocation();
        IPath requestedPath = resource.getLocation();
        if (wcPath == null || resourcePath == null || requestedPath == null) {
            return null;
        }
        String projectPath = wcPath.toString();
        int subPathStart = projectPath.length();
        boolean hasSVNMeta = true;
        while (!this.canFetchStatuses(resourcePath)) {
            if (target == null || target.getType() == 4) {
                return null;
            }
            hasSVNMeta = false;
            recursively = false;
            resourcePath = resourcePath.removeLastSegments(1);
            target = target.getParent();
        }
        IRepositoryResource baseResource = provider.getRepositoryResource();
        Status[] statuses = this.getStatuses(baseResource.getRepositoryLocation(), resourcePath.toString(), recursively);
        String desiredUrl = this.makeUrl(target, baseResource);
        ILocalResource retVal = this.fillCache(statuses, desiredUrl, resource, subPathStart, requestedPath);
        if (statuses.length == 1 || statuses.length > 1 && this.parent2Children.get(target.getFullPath()) == null) {
            this.parent2Children.put(target.getFullPath(), new HashSet());
        }
        if (retVal != null && hasSVNMeta && !recursively && statuses.length > 1 && !noCache) {
            this.scheduleStatusesFetch(statuses, target);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleStatusesFetch(Status[] st, IResource target) {
        LinkedList linkedList = this.fetchQueue;
        synchronized (linkedList) {
            this.fetchQueue.add(new Object[]{st, target});
            if (this.fetchQueue.size() == 1) {
                ProgressMonitorUtility.doTaskScheduledDefault(new AbstractActionOperation("Operation.UpdateSVNCache"){

                    public ISchedulingRule getSchedulingRule() {
                        return null;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void runImpl(IProgressMonitor monitor) throws Exception {
                        Thread.currentThread().setPriority(1);
                        while (CoreExtensionsManager.instance().getOptionProvider().isSVNCacheEnabled()) {
                            IResource target;
                            Status[] st;
                            LinkedList linkedList = SVNRemoteStorage.this.fetchQueue;
                            synchronized (linkedList) {
                                if (SVNRemoteStorage.this.fetchQueue.size() == 0) {
                                    break;
                                }
                                Object[] entry = (Object[])SVNRemoteStorage.this.fetchQueue.get(0);
                                st = (Status[])entry[0];
                                target = (IResource)entry[1];
                            }
                            this.processEntry(monitor, st, target);
                            linkedList = SVNRemoteStorage.this.fetchQueue;
                            synchronized (linkedList) {
                                SVNRemoteStorage.this.fetchQueue.remove(0);
                            }
                        }
                        if (!CoreExtensionsManager.instance().getOptionProvider().isSVNCacheEnabled()) {
                            LinkedList linkedList = SVNRemoteStorage.this.fetchQueue;
                            synchronized (linkedList) {
                                SVNRemoteStorage.this.fetchQueue.clear();
                            }
                        }
                    }

                    protected void processEntry(IProgressMonitor monitor, Status[] st, IResource target) {
                        IProject prj = target.getProject();
                        IPath location = prj.getLocation();
                        if (location != null) {
                            SVNUtility.reorder(st, false);
                            int projectEnd = location.toString().length();
                            int i = 0;
                            while (i < st.length && !monitor.isCanceled() && CoreExtensionsManager.instance().getOptionProvider().isSVNCacheEnabled()) {
                                ProgressMonitorUtility.progress(monitor, i, -1);
                                if (st[i].nodeKind == 2 && st[i].path.length() > projectEnd) {
                                    IFolder folder = prj.getFolder((IPath)new Path(st[i].path.substring(projectEnd)));
                                    ProgressMonitorUtility.setTaskInfo(monitor, this, folder.getFullPath().toString());
                                    ILocalFolder local = (ILocalFolder)SVNRemoteStorage.this.asLocalResource((IResource)folder);
                                    if (local != null) {
                                        local.getChildren();
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                }, false).setPriority(50);
            }
        }
    }

    protected boolean canFetchStatuses(IPath path) {
        return path.append(SVNUtility.getSVNFolderName()).toFile().exists();
    }

    protected Status[] getStatuses(IRepositoryLocation location, String path, boolean recursively) throws Exception {
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        try {
            Status[] statuses = proxy.status(path, recursively, false, true, true, true, false, new SVNNullProgressMonitor());
            SVNUtility.reorder(statuses, true);
            Status[] statusArray = statuses;
            Object var6_9 = null;
            location.releaseSVNProxy(proxy);
            return statusArray;
        }
        catch (ClientWrapperException cwe) {
            try {
                if (cwe.getErrorId() != 155007) {
                    throw cwe;
                }
                Status[] statusArray = new Status[]{};
                Object var6_10 = null;
                location.releaseSVNProxy(proxy);
                return statusArray;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                location.releaseSVNProxy(proxy);
                throw throwable;
            }
        }
    }

    protected ILocalResource fillCache(Status[] statuses, String desiredUrl, IResource resource, int subPathStart, IPath requestedPath) {
        IProject project = resource.getProject();
        ILocalResource retVal = null;
        int i = 0;
        while (i < statuses.length) {
            block11: {
                ILocalResource local;
                Object tRes;
                block17: {
                    block14: {
                        int externalMask;
                        int nodeKind;
                        block16: {
                            block15: {
                                String nodePath;
                                block13: {
                                    block12: {
                                        nodeKind = SVNUtility.getNodeKind(statuses[i].path, statuses[i].nodeKind, true);
                                        if (nodeKind == 0) break block11;
                                        nodePath = statuses[i].path;
                                        String string = nodePath = nodePath.length() >= subPathStart ? nodePath.substring(subPathStart) : "";
                                        if (nodePath.length() <= 0 || nodePath.charAt(nodePath.length() - 1) != '/') break block12;
                                        nodePath = nodePath.substring(0, nodePath.length() - 1);
                                        break block13;
                                    }
                                    if (i > 0 && nodePath.trim().length() == 0) break block11;
                                }
                                tRes = null;
                                tRes = new Path(statuses[i].path).equals((Object)requestedPath) && (resource.getType() > 2 || resource.getType() == nodeKind) ? resource : (nodeKind == 2 ? (nodePath.length() == 0 ? project : project.getFolder((IPath)new Path(nodePath))) : project.getFile((IPath)new Path(nodePath)));
                                local = (ILocalResource)this.localResources.get(tRes.getFullPath());
                                if (local != null) break block14;
                                int n = externalMask = statuses[i].textStatus == 13 ? 32 : 0;
                                if (externalMask == 0) break block15;
                                statuses[i] = SVNUtility.getSVNInfoForNotConnected(tRes);
                                if (statuses[i] != null) break block16;
                                break block11;
                            }
                            ILocalResource parent = this.getFirstExistingParentLocal((IResource)tRes);
                            if (parent != null && (parent.getChangeMask() & 0x20) != 0) {
                                externalMask = 32;
                            }
                        }
                        int changeMask = this.getChangeMask(statuses[i].textStatus, statuses[i].propStatus, statuses[i].isCopied, statuses[i].isSwitched);
                        if (statuses[i].lockToken != null) {
                            changeMask |= 0x10;
                        }
                        changeMask |= externalMask;
                        String status = this.getStatusString(statuses[i].propStatus, statuses[i].textStatus, false);
                        if (!statuses[i].isSwitched && statuses[i].url != null && !SVNUtility.decodeURL(statuses[i].url).startsWith(desiredUrl)) {
                            changeMask |= 8;
                        }
                        if ((changeMask & 8) != 0) {
                            this.switchedToUrls.put(tRes.getFullPath(), SVNUtility.decodeURL(statuses[i].url));
                        }
                        if (status == "Deleted" && nodeKind == 1 && new File(statuses[i].path).exists()) {
                            status = "Prereplaced";
                        }
                        if (FileUtility.isLinked(tRes)) {
                            status = "Linked";
                        } else if (status != "Obstructed" && statuses[i].textStatus == 5) {
                            status = this.getDelegatedStatus((IResource)tRes, "New", changeMask);
                        }
                        if (status == "New" && this.canFetchStatuses(tRes.getLocation())) {
                            status = "Obstructed";
                        }
                        local = this.registerResource((IResource)tRes, statuses[i].lastChangedRevision, status, changeMask, statuses[i].lastCommitAuthor, statuses[i].lastChangedDate);
                        break block17;
                    }
                    this.writeChild(local.getResource(), local.getStatus(), local.getChangeMask());
                }
                if (tRes == resource) {
                    retVal = local;
                }
            }
            ++i;
        }
        return retVal;
    }

    protected String getDelegatedStatus(IResource resource, String status, int mask) {
        if (IStateFilter.SF_LINKED.accept(resource, status, mask) || FileUtility.isLinked(resource)) {
            return "Linked";
        }
        if (IStateFilter.SF_OBSTRUCTED.accept(resource, status, mask)) {
            return "Obstructed";
        }
        if (IStateFilter.SF_IGNORED.accept(resource, status, mask) || SVNUtility.isIgnored(resource)) {
            return "None";
        }
        return this.getTopLevelStatus(resource, status, mask);
    }

    protected String getTopLevelStatus(IResource resource, String status, int mask) {
        ILocalResource topLevel = this.getFirstExistingParentLocal(resource);
        if (topLevel != null) {
            String topLevelStatus = topLevel.getStatus();
            IResource topLevelResource = topLevel.getResource();
            if (IStateFilter.SF_OBSTRUCTED.accept(topLevelResource, topLevelStatus, mask) || IStateFilter.SF_LINKED.accept(topLevelResource, topLevelStatus, mask) || IStateFilter.SF_IGNORED.accept(topLevelResource, topLevelStatus, mask)) {
                return topLevelStatus;
            }
        }
        return status;
    }

    protected ILocalResource registerResource(IResource current, long revision, String status, int changeMask, String author, long date) {
        SVNLocalResource local = null;
        if (IStateFilter.SF_OBSTRUCTED.accept(current, status, changeMask)) {
            try {
                IIgnoreRecommendations[] ignores = CoreExtensionsManager.instance().getIgnoreRecommendations();
                int i = 0;
                while (i < ignores.length) {
                    if (ignores[i].isAcceptableNature(current) && ignores[i].isOutput(current)) {
                        IPath location = current.getProject().getLocation();
                        if (location != null) {
                            String projectPath = location.removeLastSegments(1).toString();
                            File checkedResource = new File(String.valueOf(projectPath) + current.getFullPath().toString());
                            status = !checkedResource.exists() ? IStateFilter.ST_NOTEXISTS : "None";
                            IPath invalidMetaPath = new Path(String.valueOf(projectPath) + current.getFullPath().toString()).append(SVNUtility.getSVNFolderName());
                            FileUtility.deleteRecursive(invalidMetaPath.toFile());
                        }
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
        if (IStateFilter.SF_NONVERSIONED.accept(current, status, changeMask) && !IStateFilter.SF_PREREPLACEDREPLACED.accept(current, status, changeMask) && !IStateFilter.SF_DELETED.accept(current, status, changeMask) || IStateFilter.SF_LINKED.accept(current, status, changeMask)) {
            revision = -1L;
            author = null;
            date = -1L;
        }
        local = current instanceof IContainer ? new SVNLocalFolder(current, revision, status, changeMask, author, date) : new SVNLocalFile(current, revision, status, changeMask, author, date);
        this.writeChild(current, status, changeMask);
        this.localResources.put(current.getFullPath(), local);
        return local;
    }

    protected void writeChild(IResource current, String status, int mask) {
        if (!SF_NONSVN.accept(current, status, mask)) {
            IContainer parent = current.getParent();
            HashSet<IResource> children = (HashSet<IResource>)this.parent2Children.get(parent.getFullPath());
            if (children == null) {
                children = new HashSet<IResource>();
                this.parent2Children.put(parent.getFullPath(), children);
            }
            children.add(current);
        }
    }

    protected ILocalResource getFirstExistingParentLocal(IResource node) {
        IContainer parent = node.getParent();
        if (parent == null) {
            return null;
        }
        ILocalResource local = (ILocalResource)this.localResources.get(parent.getFullPath());
        if (local != null) {
            return local;
        }
        return this.getFirstExistingParentLocal((IResource)parent);
    }

    protected String deserializeStatus(String status) {
        if ("null".equals(status)) {
            return IStateFilter.ST_NOTEXISTS;
        }
        if ("None".equals(status)) {
            return "None";
        }
        if ("New".equals(status)) {
            return "New";
        }
        if ("Added".equals(status)) {
            return "Added";
        }
        if ("Normal".equals(status)) {
            return "Normal";
        }
        if ("Modified".equals(status)) {
            return "Modified";
        }
        if ("Conflicting".equals(status)) {
            return "Conflicting";
        }
        if ("Deleted".equals(status)) {
            return "Deleted";
        }
        if ("Missing".equals(status)) {
            return "Missing";
        }
        if ("Obstructed".equals(status)) {
            return "Obstructed";
        }
        if ("Prereplaced".equals(status)) {
            return "Prereplaced";
        }
        if ("Replaced".equals(status)) {
            return "Replaced";
        }
        throw new RuntimeException(SVNTeamPlugin.instance().getResource("Error.UnknownStatus"));
    }

    protected String getStatusString(int propKind, int textKind, boolean isRemoteStatus) {
        String status = "Normal";
        switch (textKind) {
            case 11: {
                status = "None";
                break;
            }
            case 5: {
                status = isRemoteStatus ? IStateFilter.ST_NOTEXISTS : "New";
                break;
            }
            case 3: {
                status = "Added";
                break;
            }
            case 4: {
                status = "Deleted";
                break;
            }
            case 6: {
                status = "Missing";
                break;
            }
            case 9: {
                status = isRemoteStatus ? "Modified" : "Conflicting";
                break;
            }
            case 2: {
                status = "Modified";
                break;
            }
            case 10: {
                status = "Obstructed";
                break;
            }
            case 7: {
                status = "Replaced";
                break;
            }
            case 0: {
                if (isRemoteStatus) break;
                status = IStateFilter.ST_NOTEXISTS;
            }
        }
        if (status == "Normal" && (propKind == 2 || propKind == 9)) {
            status = "Modified";
        }
        return status;
    }

    protected int getChangeMask(int textStatus, int propKind, boolean isCopied, boolean isSwitched) {
        int changeMask = 0;
        if (propKind == 2 || propKind == 9) {
            changeMask |= 2;
        }
        if (textStatus != 1) {
            changeMask |= 1;
        }
        if (isCopied) {
            changeMask |= 4;
        }
        if (isSwitched) {
            changeMask |= 8;
        }
        return changeMask;
    }

    private SVNRemoteStorage() {
        this.externalsLocations = new HashMap();
        this.resourceStateListeners = new HashMap();
        this.fetchQueue = new LinkedList();
    }
}

