/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.svnstorage;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.polarion.team.svn.core.client.LogMessage;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.remote.GetLogMessagesOperation;
import org.polarion.team.svn.core.resource.ICommentProvider;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryRoot;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;

public class CommentProvider
implements ICommentProvider {
    public String getComment(IResource resource, Revision rev, Revision peg) {
        LogMessage[] msgs;
        if (rev.getKind() == 1 && ((Revision.Number)rev).getNumber() == -1L || peg != null && peg.getKind() == 1 && ((Revision.Number)peg).getNumber() == -1L) {
            return null;
        }
        IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(resource);
        if (location == null) {
            return null;
        }
        IRepositoryRoot remote = location.getRepositoryRoot();
        remote.setSelectedRevision(rev);
        remote.setPegRevision(peg);
        GetLogMessagesOperation op = new GetLogMessagesOperation(remote);
        op.setLimit(1L);
        ProgressMonitorUtility.doTaskExternalDefault(op, (IProgressMonitor)new NullProgressMonitor());
        if (op.getExecutionState() == 0 && (msgs = op.getMessages()).length > 0) {
            return msgs[0].message;
        }
        return null;
    }
}

