/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.resource.events;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.polarion.team.svn.core.utility.FileUtility;

public class ResourceStatesChangedEvent {
    public final IResource[] resources;
    public final int depth;
    private IResource[] fullSet;

    public ResourceStatesChangedEvent(IResource[] resources, int depth) {
        this.resources = resources;
        FileUtility.reorder(resources, true);
        this.depth = depth;
        if (this.depth == 0) {
            this.fullSet = this.resources;
        }
    }

    public IResource[] getResourcesRecursivelly() {
        if (this.fullSet == null) {
            try {
                this.fullSet = ResourceStatesChangedEvent.collectResources(this.resources, this.depth);
                FileUtility.reorder(this.fullSet, true);
            }
            catch (CoreException coreException) {
                this.fullSet = this.resources;
            }
        }
        return this.fullSet;
    }

    public boolean contains(IResource resource) {
        if (this.containsImpl(resource)) {
            return true;
        }
        if (this.depth != 0) {
            if (this.containsImpl((IResource)resource.getParent())) {
                return true;
            }
            if (this.depth != 1) {
                IPath path = resource.getFullPath();
                int i = 0;
                while (i < this.resources.length) {
                    if (this.resources[i].getFullPath().isPrefixOf(path)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public static IResource[] collectResources(IResource[] resources, int depth) throws CoreException {
        if (depth == 0) {
            return resources;
        }
        final ArrayList fullList = new ArrayList();
        int i = 0;
        while (i < resources.length) {
            FileUtility.visitNodes(resources[i], new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (FileUtility.isSVNInternals(resource)) {
                        return false;
                    }
                    fullList.add(resource);
                    return true;
                }
            }, depth);
            ++i;
        }
        return fullList.toArray(new IResource[fullList.size()]);
    }

    protected boolean containsImpl(IResource resource) {
        int i = 0;
        while (i < this.resources.length) {
            if (this.resources[i].equals((Object)resource)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

