/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.remote.management;

import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryResourceProvider;
import org.polarion.team.svn.core.utility.SVNUtility;

public class AddRevisionLinkOperation
extends AbstractRepositoryOperation {
    protected Revision revision;

    public AddRevisionLinkOperation(IRepositoryResource resource, long revision) {
        this(resource, Revision.getInstance(revision));
    }

    public AddRevisionLinkOperation(IRepositoryResource resource, Revision revision) {
        super("Operation.AddRevisionLink", new IRepositoryResource[]{resource});
        this.revision = revision;
    }

    public AddRevisionLinkOperation(IRepositoryResourceProvider provider, long revision) {
        this(provider, Revision.getInstance(revision));
    }

    public AddRevisionLinkOperation(IRepositoryResourceProvider provider, Revision revision) {
        super("Operation.AddRevisionLink", provider);
        this.revision = revision;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] resources = this.operableData();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            final IRepositoryResource source = resources[0];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    Revision pegRevision;
                    IRepositoryLocation location = source.getRepositoryLocation();
                    IRepositoryResource target = SVNUtility.copyOf(source);
                    Revision selectedRevision = AddRevisionLinkOperation.this.revision;
                    if (selectedRevision.equals(Revision.HEAD)) {
                        selectedRevision = Revision.getInstance(source.getRevision());
                    }
                    if ((pegRevision = source.getPegRevision()).equals(Revision.HEAD)) {
                        pegRevision = Revision.getInstance(location.getRepositoryRoot().getRevision());
                    }
                    target.setSelectedRevision(selectedRevision);
                    target.setPegRevision(pegRevision);
                    location.addRevisionLink(target);
                }
            }, monitor, resources.length);
            ++i;
        }
    }
}

