/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.remote;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Notify2;
import org.polarion.team.svn.core.client.NotifyInformation;
import org.polarion.team.svn.core.operation.IRevisionProvider;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class RenameResourceOperation
extends AbstractRepositoryOperation
implements IRevisionProvider {
    protected String message;
    protected String newName;
    protected IRevisionProvider.RevisionPair[] revisionPair;

    public RenameResourceOperation(IRepositoryResource resource, String newName, String message) {
        super("Operation.Rename", new IRepositoryResource[]{resource});
        this.message = message;
        this.newName = newName;
    }

    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionPair;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource resource = this.operableData()[0];
        this.revisionPair = new IRevisionProvider.RevisionPair[1];
        final IRepositoryLocation location = resource.getRepositoryLocation();
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        final String newUrl = String.valueOf(resource.getParent().getUrl()) + "/" + this.newName;
        Notify2 notify = new Notify2(){

            public void onNotify(NotifyInformation info) {
                String[] path = new String[]{newUrl};
                RenameResourceOperation.this.revisionPair[0] = new IRevisionProvider.RevisionPair(info.revision, path, location);
                String message = SVNTeamPlugin.instance().getResource("Console.CommittedRevision");
                RenameResourceOperation.this.writeToConsole(1, MessageFormat.format(message, String.valueOf(info.revision)));
            }
        };
        try {
            SVNUtility.addSVNNotifyListener(proxy, notify);
            this.writeToConsole(0, "svn move \"" + resource.getUrl() + "\" \"" + newUrl + "\" -m \"" + this.message + "\"" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            proxy.move(SVNUtility.encodeURL(resource.getUrl()), SVNUtility.encodeURL(newUrl), this.message, resource.getSelectedRevision(), false, new SVNProgressMonitor(this, monitor, null));
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            SVNUtility.removeSVNNotifyListener(proxy, notify);
            resource.getRepositoryLocation().releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        SVNUtility.removeSVNNotifyListener(proxy, notify);
        resource.getRepositoryLocation().releaseSVNProxy(proxy);
    }

    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), this.operableData()[0].getName(), this.newName);
    }
}

