/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ChangePath;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.LogMessage;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.polarion.team.svn.core.operation.remote.GetLogMessagesOperation;
import org.polarion.team.svn.core.resource.IRepositoryFile;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryResourceProvider;
import org.polarion.team.svn.core.utility.SVNUtility;

public class LocateResourceURLInHistoryOperation
extends AbstractRepositoryOperation
implements IRepositoryResourceProvider {
    protected IRepositoryResource[] converted;
    protected boolean pegAsSelected;

    public LocateResourceURLInHistoryOperation(IRepositoryResource[] resources, boolean pegAsSelected) {
        super("Operation.LocateURLInHistory", resources);
        this.pegAsSelected = pegAsSelected;
    }

    public LocateResourceURLInHistoryOperation(IRepositoryResourceProvider provider, boolean pegAsSelected) {
        super("Operation.LocateURLInHistory", provider);
        this.pegAsSelected = pegAsSelected;
    }

    public IRepositoryResource[] getRepositoryResources() {
        return this.converted;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] resources = this.operableData();
        this.converted = new IRepositoryResource[resources.length];
        System.arraycopy(resources, 0, this.converted, 0, resources.length);
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            final int idx = i;
            if (this.converted[i].getSelectedRevision().getKind() == 1) {
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        IRepositoryResource result = LocateResourceURLInHistoryOperation.this.processEntry(LocateResourceURLInHistoryOperation.this.converted[idx], monitor);
                        IRepositoryResource iRepositoryResource = LocateResourceURLInHistoryOperation.this.converted[idx] = LocateResourceURLInHistoryOperation.this.converted[idx] == result ? SVNUtility.copyOf(result) : result;
                        if (LocateResourceURLInHistoryOperation.this.pegAsSelected) {
                            LocateResourceURLInHistoryOperation.this.converted[idx].setPegRevision(LocateResourceURLInHistoryOperation.this.converted[idx].getSelectedRevision());
                        }
                    }
                }, monitor, resources.length);
            }
            ++i;
        }
    }

    protected IRepositoryResource processEntry(IRepositoryResource current, IProgressMonitor monitor) throws Exception {
        ISVNClientWrapper proxy;
        IRepositoryLocation location;
        block8: {
            Revision searchRevision;
            long rev;
            String copiedFrom;
            block11: {
                int idx;
                String pattern;
                ChangePath[] paths;
                block10: {
                    block9: {
                        location = current.getRepositoryLocation();
                        proxy = location.acquireSVNProxy();
                        LogMessage[] msgs = GetLogMessagesOperation.getMessagesImpl(proxy, current, Revision.getInstance(0L), current.getPegRevision(), 1L, true, this, monitor);
                        if (msgs == null || msgs.length <= 0 || msgs[0] == null) break block8;
                        paths = msgs[0].changedPaths;
                        if (paths != null) break block9;
                        IRepositoryResource iRepositoryResource = current;
                        Object var17_12 = null;
                        location.releaseSVNProxy(proxy);
                        return iRepositoryResource;
                    }
                    try {
                        pattern = current.getUrl().substring(location.getRepositoryRoot().getUrl().length());
                        idx = -1;
                        int i = 0;
                        while (i < paths.length) {
                            if (paths[i].action != 'D' && pattern.startsWith(paths[i].path)) {
                                if (paths[i].copySrcPath == null) break;
                                idx = i;
                                break;
                            }
                            ++i;
                        }
                        if (idx != -1) break block10;
                        IRepositoryResource iRepositoryResource = current;
                        Object var17_13 = null;
                        location.releaseSVNProxy(proxy);
                        return iRepositoryResource;
                    }
                    catch (Throwable throwable) {
                        Object var17_17 = null;
                        location.releaseSVNProxy(proxy);
                        throw throwable;
                    }
                }
                copiedFrom = String.valueOf(location.getRepositoryRoot().getUrl()) + paths[idx].copySrcPath + pattern.substring(paths[idx].path.length());
                rev = paths[idx].copySrcRevision;
                searchRevision = current.getSelectedRevision();
                long searchRev = ((Revision.Number)searchRevision).getNumber();
                if (rev >= searchRev) break block11;
                IRepositoryResource iRepositoryResource = current;
                Object var17_14 = null;
                location.releaseSVNProxy(proxy);
                return iRepositoryResource;
            }
            Revision revison = Revision.getInstance(rev);
            IRepositoryResource retVal = current instanceof IRepositoryFile ? location.asRepositoryFile(copiedFrom, false) : location.asRepositoryContainer(copiedFrom, false);
            retVal.setPegRevision(revison);
            retVal.setSelectedRevision(searchRevision);
            IRepositoryResource iRepositoryResource = this.processEntry(retVal, monitor);
            Object var17_15 = null;
            location.releaseSVNProxy(proxy);
            return iRepositoryResource;
        }
        IRepositoryResource iRepositoryResource = current;
        Object var17_16 = null;
        location.releaseSVNProxy(proxy);
        return iRepositoryResource;
    }
}

