/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.remote;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.BlameCallback;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.SVNUtility;

public class GetResourceAnnotationOperation
extends AbstractRepositoryOperation {
    protected String[][] annotatedLines;
    protected byte[] content;

    public GetResourceAnnotationOperation(IRepositoryResource resource) {
        super("Operation.GetAnnotation", new IRepositoryResource[]{resource});
    }

    public IRepositoryResource getRepositoryResource() {
        return this.operableData()[0];
    }

    public String[][] getAnnotatedLines() {
        return this.annotatedLines;
    }

    public byte[] getContent() {
        return this.content;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        final ByteArrayOutputStream stream = new ByteArrayOutputStream();
        final ArrayList lines = new ArrayList();
        IRepositoryResource resource = this.operableData()[0];
        IRepositoryLocation location = resource.getRepositoryLocation();
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        try {
            String url = SVNUtility.encodeURL(resource.getUrl());
            proxy.blame(url, resource.getPegRevision(), Revision.getInstance(0L), resource.getSelectedRevision(), new BlameCallback(){
                protected int lineNumber = 0;
                protected String noAuthor = SVNTeamPlugin.instance().getResource("SVNInfo.NoAuthor");

                public void singleLine(long changed, long revision, String author, String line) {
                    String[] row = new String[]{String.valueOf(revision), author == null ? this.noAuthor : author, String.valueOf(++this.lineNumber)};
                    lines.add(row);
                    try {
                        stream.write((String.valueOf(line) + "\n").getBytes());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }, new SVNProgressMonitor(this, monitor, null));
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var8_10 = null;
            location.releaseSVNProxy(proxy);
        }
        this.annotatedLines = (String[][])lines.toArray((T[])new String[lines.size()][]);
        this.content = stream.toByteArray();
    }

    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), this.operableData()[0].getUrl());
    }
}

