/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.remote;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.LogMessage;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryResourceProvider;
import org.polarion.team.svn.core.utility.SVNUtility;

public class GetLogMessagesOperation
extends AbstractRepositoryOperation {
    protected LogMessage[] msg;
    protected boolean stopOnCopy;
    protected Revision selectedRevision;
    protected long limit;

    public GetLogMessagesOperation(IRepositoryResourceProvider provider) {
        super("Operation.GetLogMessages", provider);
        this.stopOnCopy = false;
    }

    public GetLogMessagesOperation(IRepositoryResource resource) {
        this(resource, false);
    }

    public GetLogMessagesOperation(IRepositoryResource resource, boolean stopOnCopy) {
        super("Operation.GetLogMessages", new IRepositoryResource[]{resource});
        this.stopOnCopy = stopOnCopy;
        this.limit = 0L;
    }

    public boolean getStopOnCopy() {
        return this.stopOnCopy;
    }

    public void setStopOnCopy(boolean stopOnCopy) {
        this.stopOnCopy = stopOnCopy;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public void setSelectedRevision(Revision revision) {
        this.selectedRevision = revision;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource resource = this.operableData()[0];
        if (this.selectedRevision == null) {
            this.selectedRevision = resource.getSelectedRevision();
        }
        IRepositoryLocation location = resource.getRepositoryLocation();
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        try {
            this.msg = GetLogMessagesOperation.getMessagesImpl(proxy, resource, this.selectedRevision, Revision.getInstance(0L), this.limit, this.stopOnCopy, this, monitor);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var5_7 = null;
            location.releaseSVNProxy(proxy);
            return;
        }
    }

    public LogMessage[] getMessages() {
        return this.msg;
    }

    public IRepositoryResource getResource() {
        return this.operableData()[0];
    }

    public static LogMessage[] getMessagesImpl(ISVNClientWrapper proxy, IRepositoryResource resource, Revision from, Revision to, long limit, boolean stopOnCopy, IActionOperation parent, IProgressMonitor monitor) throws Exception {
        return proxy.logMessages(SVNUtility.encodeURL(resource.getUrl()), resource.getPegRevision(), from, to, stopOnCopy, true, limit, new SVNProgressMonitor(parent, monitor, null));
    }

    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), this.operableData()[0].getUrl());
    }
}

