/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.remote;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Notify2;
import org.polarion.team.svn.core.client.NotifyInformation;
import org.polarion.team.svn.core.operation.IRevisionProvider;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class CreateFolderOperation
extends AbstractRepositoryOperation
implements IRevisionProvider {
    protected String[] names;
    protected String comment;
    protected IRevisionProvider.RevisionPair[] revisionPair;

    public CreateFolderOperation(IRepositoryResource parent, String name, String comment) {
        this(parent, new String[]{name}, comment);
    }

    public CreateFolderOperation(IRepositoryResource parent, String[] names, String comment) {
        super("Operation.CreateFolder", new IRepositoryResource[]{parent});
        this.names = names;
        this.comment = comment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.revisionPair = new IRevisionProvider.RevisionPair[1];
        IRepositoryResource parent = this.operableData()[0];
        IRepositoryLocation location = parent.getRepositoryLocation();
        ProgressMonitorUtility.setTaskInfo(monitor, this, String.valueOf(parent.getUrl()) + "/" + this.names[0]);
        HashSet<IRepositoryResource> fullSet = new HashSet<IRepositoryResource>();
        int i = 0;
        while (i < this.names.length) {
            fullSet.addAll(Arrays.asList(SVNUtility.makeResourceSet(parent, this.names[i], false)));
            ++i;
        }
        IRepositoryResource[] toBeCreated = fullSet.toArray(new IRepositoryResource[fullSet.size()]);
        Object[] childUrls = SVNUtility.asURLArray(toBeCreated, true);
        FileUtility.sort(childUrls);
        Notify2 notify = new Notify2((String[])childUrls, location){
            private final /* synthetic */ String[] val$childUrls;
            private final /* synthetic */ IRepositoryLocation val$location;
            {
                this.val$childUrls = stringArray;
                this.val$location = iRepositoryLocation;
            }

            public void onNotify(NotifyInformation info) {
                String[] path = this.val$childUrls;
                CreateFolderOperation.this.revisionPair[0] = new IRevisionProvider.RevisionPair(info.revision, path, this.val$location);
                String message = SVNTeamPlugin.instance().getResource("Console.CommittedRevision");
                CreateFolderOperation.this.writeToConsole(1, MessageFormat.format(message, String.valueOf(info.revision)));
            }
        };
        this.complexWriteToConsole(new Runnable((String[])childUrls, monitor, location){
            private final /* synthetic */ String[] val$childUrls;
            private final /* synthetic */ IProgressMonitor val$monitor;
            private final /* synthetic */ IRepositoryLocation val$location;
            {
                this.val$childUrls = stringArray;
                this.val$monitor = iProgressMonitor;
                this.val$location = iRepositoryLocation;
            }

            public void run() {
                CreateFolderOperation.this.writeToConsole(0, "svn mkdir");
                int i = 0;
                while (i < this.val$childUrls.length && !this.val$monitor.isCanceled()) {
                    CreateFolderOperation.this.writeToConsole(0, " \"" + SVNUtility.decodeURL(this.val$childUrls[i]) + "\"");
                    ++i;
                }
                CreateFolderOperation.this.writeToConsole(0, " -m \"" + CreateFolderOperation.this.comment + "\"" + FileUtility.getUsernameParam(this.val$location.getUsername()) + "\n");
            }
        });
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        try {
            SVNUtility.addSVNNotifyListener(proxy, notify);
            proxy.mkdir((String[])childUrls, this.comment, new SVNProgressMonitor(this, monitor, null));
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            SVNUtility.removeSVNNotifyListener(proxy, notify);
            parent.getRepositoryLocation().releaseSVNProxy(proxy);
            throw throwable;
        }
        SVNUtility.removeSVNNotifyListener(proxy, notify);
        parent.getRepositoryLocation().releaseSVNProxy(proxy);
        ProgressMonitorUtility.progress(monitor, 1, 1);
    }

    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionPair;
    }

    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), this.name);
    }
}

