/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local.refactor;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.AbstractActionOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;

public class CopyResourceWithHistoryOperation
extends AbstractActionOperation {
    protected IResource source;
    protected IResource destination;

    public CopyResourceWithHistoryOperation(IResource source, IResource destination) {
        super("Operation.CopyLocalH");
        this.source = source;
        this.destination = destination;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.destination instanceof IProject ? this.destination : this.destination.getParent();
    }

    public boolean isAllowed() {
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        IRepositoryLocation locationSource = storage.getRepositoryLocation(this.source);
        IRepositoryLocation locationDestination = storage.getRepositoryLocation(this.destination);
        ILocalResource localSource = storage.asLocalResource(this.source);
        return localSource != null && IStateFilter.SF_ONREPOSITORY.accept(this.source, localSource.getStatus(), localSource.getChangeMask()) && locationSource.equals(locationDestination);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        IRepositoryLocation location = storage.getRepositoryLocation(this.source);
        ISVNClientWrapper proxy = location.acquireSVNProxy();
        try {
            this.writeToConsole(0, "svn copy \"" + FileUtility.normalizePath(FileUtility.getWorkingCopyPath(this.source)) + "\" \"" + FileUtility.getWorkingCopyPath(this.destination) + "\"\n");
            proxy.copy(FileUtility.getWorkingCopyPath(this.source), FileUtility.getWorkingCopyPath(this.destination), null, Revision.WORKING, new SVNProgressMonitor(this, monitor, null));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            location.releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var5_7 = null;
            location.releaseSVNProxy(proxy);
            return;
        }
    }

    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), this.source.getName(), this.destination.toString());
    }
}

