/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local.property;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.ISVNProgressMonitor;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.operation.IResourcePropertyProvider;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;

public class SetPropertiesOperation
extends AbstractWorkingCopyOperation {
    protected PropertyData[] propertyData;
    protected boolean isRecursive;
    protected IResourcePropertyProvider propertyProvider;

    public SetPropertiesOperation(IResource[] resources, String name, byte[] data, boolean isRecursive) {
        this(resources, new PropertyData[]{new PropertyData(name, null, data)}, isRecursive);
    }

    public SetPropertiesOperation(IResource[] resources, PropertyData[] data, boolean isRecursive) {
        super("Operation.SetProperties", resources);
        this.propertyData = data;
        this.isRecursive = isRecursive;
    }

    public SetPropertiesOperation(IResourceProvider resourceProvider, PropertyData[] data, boolean isRecursive) {
        super("Operation.SetProperties", resourceProvider);
        this.propertyData = data;
        this.isRecursive = isRecursive;
    }

    public SetPropertiesOperation(IResource[] resources, IResourcePropertyProvider propertyProvider, boolean isRecursive) {
        super("Operation.SetProperties", resources);
        this.propertyProvider = propertyProvider;
        this.isRecursive = isRecursive;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        if (this.isRecursive) {
            resources = FileUtility.shrinkChildNodes(resources);
        }
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            final IResource resource = resources[i];
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(resource);
            final ISVNClientWrapper proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    SetPropertiesOperation.this.processResource(proxy, resource, monitor);
                }
            }, monitor, resources.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }

    protected void processResource(final ISVNClientWrapper proxy, IResource resource, IProgressMonitor monitor) {
        ProgressMonitorUtility.setTaskInfo(monitor, this, resource.getFullPath().toString());
        final String wcPath = FileUtility.getWorkingCopyPath(resource);
        PropertyData[] properties = this.getOperableProperties();
        int i = 0;
        while (i < properties.length && !monitor.isCanceled()) {
            final PropertyData current = properties[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.propertySet(wcPath, current.name, current.data == null ? current.value.getBytes() : current.data, SetPropertiesOperation.this.isRecursive, (ISVNProgressMonitor)new SVNProgressMonitor(SetPropertiesOperation.this, monitor, null));
                }
            }, monitor, properties.length);
            ++i;
        }
    }

    protected PropertyData[] getOperableProperties() {
        return this.propertyData == null ? this.propertyProvider.getProperties() : this.propertyData;
    }
}

