/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local.property;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.ISVNProgressMonitor;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.operation.local.property.IPropertyProvider;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;

public class SetMultiPropertiesOperation
extends AbstractWorkingCopyOperation {
    protected IPropertyProvider propertyProvider;
    protected int depth;
    protected IStateFilter filter;

    public SetMultiPropertiesOperation(IResourceProvider resourceProvider, IPropertyProvider propertyProvider, IStateFilter filter, int depth) {
        super("Operation.SetMultiProperties", resourceProvider);
        this.propertyProvider = propertyProvider;
        this.depth = depth;
        this.filter = filter != null ? filter : IStateFilter.SF_VERSIONED;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            Object var7_7;
            final IResource current = resources[i];
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(current);
            final ISVNClientWrapper proxy = location.acquireSVNProxy();
            try {
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        FileUtility.visitNodes(current, new IResourceVisitor(this, monitor, proxy){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ IProgressMonitor val$monitor;
                            private final /* synthetic */ ISVNClientWrapper val$proxy;
                            {
                                this.this$1 = var1_1;
                                this.val$monitor = iProgressMonitor;
                                this.val$proxy = iSVNClientWrapper;
                            }

                            public boolean visit(IResource resource) throws CoreException {
                                PropertyData[] properties;
                                if (this.val$monitor.isCanceled()) {
                                    return false;
                                }
                                ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
                                if (local == null) {
                                    return false;
                                }
                                if (1.access$0(this.this$1).filter.accept(resource, local.getStatus(), local.getChangeMask()) && (properties = 1.access$0(this.this$1).propertyProvider.getProperties(resource)) != null) {
                                    1.access$0(this.this$1).processResource(this.val$proxy, resource, properties, this.val$monitor);
                                }
                                return 1.access$0(this.this$1).filter.allowsRecursion(resource, local.getStatus(), local.getChangeMask());
                            }
                        }, SetMultiPropertiesOperation.this.depth);
                    }

                    static /* synthetic */ SetMultiPropertiesOperation access$0(1 var0) {
                        return var0.SetMultiPropertiesOperation.this;
                    }
                }, monitor, resources.length);
            }
            catch (Throwable throwable) {
                var7_7 = null;
                location.releaseSVNProxy(proxy);
                throw throwable;
            }
            {
                var7_7 = null;
                location.releaseSVNProxy(proxy);
                ++i;
                continue;
            }
            break;
        }
        return;
    }

    protected void processResource(final ISVNClientWrapper proxy, IResource current, PropertyData[] properties, IProgressMonitor monitor) {
        ProgressMonitorUtility.setTaskInfo(monitor, this, current.getFullPath().toString());
        final String wcPath = FileUtility.getWorkingCopyPath(current);
        int i = 0;
        while (i < properties.length && !monitor.isCanceled()) {
            final PropertyData property = properties[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.propertySet(wcPath, property.name, property.data == null ? property.value.getBytes() : property.data, false, (ISVNProgressMonitor)new SVNProgressMonitor(SetMultiPropertiesOperation.this, monitor, null));
                }
            }, monitor, properties.length);
            ++i;
        }
    }
}

