/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local.property;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.ProgressMonitorUtility;

public class RemovePropertiesOperation
extends AbstractWorkingCopyOperation {
    protected PropertyData[] data;
    protected boolean isRecursive;

    public RemovePropertiesOperation(IResource[] resources, PropertyData[] data, boolean isRecursive) {
        super("Operation.RemoveProperties", resources);
        this.data = data;
        this.isRecursive = isRecursive;
    }

    public RemovePropertiesOperation(IResourceProvider resourceProvider, PropertyData[] data, boolean isRecursive) {
        super("Operation.RemoveProperties", resourceProvider);
        this.data = data;
        this.isRecursive = isRecursive;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        if (this.isRecursive) {
            resources = FileUtility.shrinkChildNodes(resources);
        }
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            final IResource resource = resources[i];
            IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(resource);
            final ISVNClientWrapper proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    RemovePropertiesOperation.this.processResource(proxy, resource, monitor);
                }
            }, monitor, resources.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }

    protected void processResource(final ISVNClientWrapper proxy, IResource resource, IProgressMonitor monitor) {
        ProgressMonitorUtility.setTaskInfo(monitor, this, resource.getFullPath().toString());
        final String wcPath = FileUtility.getWorkingCopyPath(resource);
        int i = 0;
        while (i < this.data.length && !monitor.isCanceled()) {
            final PropertyData current = this.data[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.propertyRemove(wcPath, current.name, RemovePropertiesOperation.this.isRecursive, new SVNProgressMonitor(RemovePropertiesOperation.this, monitor, null));
                }
            }, monitor, this.data.length);
            ++i;
        }
    }
}

