/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local.management;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.RepositoryProvider;
import org.polarion.team.svn.core.IConnectedProjectInformation;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class RelocateWorkingCopyOperation
extends AbstractWorkingCopyOperation
implements IResourceProvider {
    protected IRepositoryLocation location;
    protected List resources;

    public RelocateWorkingCopyOperation(IResource[] resources, IRepositoryLocation location) {
        super("Operation.RelocateResources", resources);
        this.location = location;
    }

    public RelocateWorkingCopyOperation(IResourceProvider provider, IRepositoryLocation location) {
        super("Operation.RelocateResources", provider);
        this.location = location;
    }

    public IResource[] getResources() {
        return this.resources == null ? new IResource[]{} : this.resources.toArray(new IResource[this.resources.size()]);
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.resources = new ArrayList();
        IResource[] projects = this.operableData();
        if (projects.length == 0) {
            return;
        }
        final ISVNClientWrapper proxy = this.location.acquireSVNProxy();
        try {
            final IRepositoryResource[] children = this.location.getRepositoryRoot().getChildren();
            final String rootUrl = this.location.getRepositoryRootUrl();
            int i = 0;
            while (i < projects.length && !monitor.isCanceled()) {
                final IProject current = (IProject)projects[i];
                this.protectStep(new IUnprotectedOperation(){

                    public void run(IProgressMonitor monitor) throws Exception {
                        IConnectedProjectInformation provider = (IConnectedProjectInformation)RepositoryProvider.getProvider((IProject)current, (String)"org.polarion.team.svn.core.svnnature");
                        IPath fsLocation = current.getLocation();
                        if (fsLocation != null) {
                            String url;
                            String oldRoot;
                            String path = fsLocation.toString();
                            Status st = SVNUtility.getSVNInfoForNotConnected((IResource)current);
                            if (st != null && (oldRoot = SVNUtility.getOldRoot(url = SVNUtility.decodeURL(st.url), children)) != null) {
                                RelocateWorkingCopyOperation.this.writeToConsole(0, "svn switch --relocate \"" + oldRoot + "\" \"" + rootUrl + "\" \"" + FileUtility.normalizePath(path) + "\"" + FileUtility.getUsernameParam(RelocateWorkingCopyOperation.this.location.getUsername()) + "\n");
                                proxy.relocate(oldRoot, rootUrl, path, true, new SVNProgressMonitor(RelocateWorkingCopyOperation.this, monitor, null));
                                provider.relocateResource();
                                RelocateWorkingCopyOperation.this.resources.add(current);
                            }
                        }
                    }
                }, monitor, projects.length);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.location.releaseSVNProxy(proxy);
            throw throwable;
        }
        {
            Object var8_10 = null;
            this.location.releaseSVNProxy(proxy);
            return;
        }
    }

    protected String getShortErrorMessage(Throwable t) {
        return MessageFormat.format(super.getShortErrorMessage(t), this.location.getUrl());
    }
}

