/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local.management;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.SVNTeamProjectMapper;
import org.polarion.team.svn.core.client.Status;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.resource.IRepositoryContainer;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.utility.SVNUtility;

public class ReconnectProjectOperation
extends AbstractWorkingCopyOperation {
    protected IRepositoryLocation location;

    public ReconnectProjectOperation(IProject[] projects, IRepositoryLocation location) {
        super("Operation.Reconnect", (IResource[])projects);
        this.location = location;
    }

    public ReconnectProjectOperation(IResourceProvider provider, IRepositoryLocation location) {
        super("Operation.Reconnect", provider);
        this.location = location;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            final IProject project = (IProject)resources[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    Status st = SVNUtility.getSVNInfoForNotConnected((IResource)project);
                    IRepositoryContainer remote = ReconnectProjectOperation.this.location.asRepositoryContainer(SVNUtility.decodeURL(st.url), false);
                    SVNTeamProjectMapper.map(project, remote);
                }
            }, monitor, resources.length);
            ++i;
        }
    }
}

