/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local.change.visitors;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.local.change.IActionOperationProcessor;
import org.polarion.team.svn.core.operation.local.change.IResourceChangeVisitor;
import org.polarion.team.svn.core.operation.local.change.ResourceChange;
import org.polarion.team.svn.core.resource.ILocalFile;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.utility.FileUtility;

public class SaveContentVisitor
implements IResourceChangeVisitor {
    public void preVisit(ResourceChange change, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
        ILocalResource local = change.getLocal();
        if (local instanceof ILocalFile) {
            if (IStateFilter.SF_DELETED.accept(local.getResource(), local.getStatus(), local.getChangeMask()) && !IStateFilter.SF_PREREPLACEDREPLACED.accept(local.getResource(), local.getStatus(), local.getChangeMask())) {
                return;
            }
            File real = new File(FileUtility.getWorkingCopyPath(local.getResource()));
            if (real.exists() && !real.renameTo(change.getTemporary())) {
                FileUtility.copyFile(change.getTemporary(), real, monitor);
                real.delete();
            }
        }
    }

    public void postVisit(ResourceChange change, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
    }
}

