/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local.change.visitors;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.IStateFilter;
import org.polarion.team.svn.core.operation.local.AddToSVNOperation;
import org.polarion.team.svn.core.operation.local.change.IActionOperationProcessor;
import org.polarion.team.svn.core.operation.local.change.IResourceChangeVisitor;
import org.polarion.team.svn.core.operation.local.change.ResourceChange;
import org.polarion.team.svn.core.operation.local.refactor.DeleteResourceOperation;
import org.polarion.team.svn.core.resource.ILocalFile;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.utility.FileUtility;

public class RestoreContentVisitor
implements IResourceChangeVisitor {
    protected boolean nodeKindChanged;

    public RestoreContentVisitor(boolean nodeKindChanged) {
        this.nodeKindChanged = nodeKindChanged;
    }

    public void preVisit(ResourceChange change, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
    }

    public void postVisit(ResourceChange change, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
        ILocalResource local = change.getLocal();
        if (local instanceof ILocalFile) {
            File real = new File(FileUtility.getWorkingCopyPath(local.getResource()));
            boolean exists = real.exists();
            real.delete();
            if (IStateFilter.SF_DELETED.accept(local.getResource(), local.getStatus(), local.getChangeMask())) {
                if (exists && !IStateFilter.SF_MISSING.accept(local.getResource(), local.getStatus(), local.getChangeMask())) {
                    processor.doOperation(new DeleteResourceOperation(local.getResource()), monitor);
                }
                if (!IStateFilter.SF_PREREPLACEDREPLACED.accept(local.getResource(), local.getStatus(), local.getChangeMask())) {
                    return;
                }
            }
            if (change.getTemporary().exists() && !change.getTemporary().renameTo(real)) {
                File parent = real.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                FileUtility.copyFile(real, change.getTemporary(), monitor);
                change.getTemporary().delete();
            }
            if (!this.nodeKindChanged && (IStateFilter.SF_REPLACED.accept(local.getResource(), local.getStatus(), local.getChangeMask()) || !exists && IStateFilter.SF_VERSIONED.accept(local.getResource(), local.getStatus(), local.getChangeMask()))) {
                processor.doOperation(new AddToSVNOperation(new IResource[]{local.getResource()}, false), monitor);
            }
        }
    }
}

