/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local.change;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.operation.local.change.FileChange;
import org.polarion.team.svn.core.operation.local.change.FolderChange;
import org.polarion.team.svn.core.operation.local.change.IActionOperationProcessor;
import org.polarion.team.svn.core.operation.local.change.IResourceChangeVisitor;
import org.polarion.team.svn.core.resource.ILocalFile;
import org.polarion.team.svn.core.resource.ILocalFolder;
import org.polarion.team.svn.core.resource.ILocalResource;
import org.polarion.team.svn.core.utility.FileUtility;

public abstract class ResourceChange {
    protected ILocalResource local;
    protected File tmp;
    protected PropertyData[] properties;

    public ResourceChange(ResourceChange parent, ILocalResource local, boolean needsTemporary) throws Exception {
        this.local = local;
        if (needsTemporary) {
            this.tmp = File.createTempFile("merge", ".tmp", parent == null ? SVNTeamPlugin.instance().getStateLocation().toFile() : parent.getTemporary());
            this.tmp.delete();
        }
        this.properties = null;
    }

    public ILocalResource getLocal() {
        return this.local;
    }

    public PropertyData[] getProperties() {
        return this.properties;
    }

    public void setProperties(PropertyData[] properties) {
        this.properties = properties;
    }

    public File getTemporary() {
        return this.tmp;
    }

    public void disposeChangeModel(IProgressMonitor monitor) throws Exception {
        if (this.tmp != null) {
            FileUtility.deleteRecursive(this.tmp, monitor);
        }
    }

    public void traverse(IResourceChangeVisitor visitor, int depth, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
        this.preTraverse(visitor, depth, processor, monitor);
        this.postTraverse(visitor, depth, processor, monitor);
    }

    protected abstract void preTraverse(IResourceChangeVisitor var1, int var2, IActionOperationProcessor var3, IProgressMonitor var4) throws Exception;

    protected abstract void postTraverse(IResourceChangeVisitor var1, int var2, IActionOperationProcessor var3, IProgressMonitor var4) throws Exception;

    public static ResourceChange wrapLocalResource(ResourceChange parent, ILocalResource local, boolean needsTemporary) throws Exception {
        if (local == null) {
            return null;
        }
        return local instanceof ILocalFile ? new FileChange(parent, (ILocalFile)local, needsTemporary) : new FolderChange(parent, (ILocalFolder)local, needsTemporary);
    }
}

