/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.client.ISVNProgressMonitor;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.IActionOperation;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.local.AbstractConflictDetectionOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class UpdateOperation
extends AbstractConflictDetectionOperation
implements IResourceProvider {
    protected Revision selectedRevision;
    protected boolean doRecursiveUpdate;

    public UpdateOperation(IResource[] resources, boolean doRecursiveUpdate) {
        this(resources, null, doRecursiveUpdate);
    }

    public UpdateOperation(IResourceProvider provider, boolean doRecursiveUpdate) {
        this(provider, null, doRecursiveUpdate);
    }

    public UpdateOperation(IResourceProvider provider, Revision selectedRevision, boolean doRecursiveUpdate) {
        super("Operation.Update", provider);
        this.doRecursiveUpdate = doRecursiveUpdate;
        this.selectedRevision = selectedRevision == null ? Revision.HEAD : selectedRevision;
    }

    public UpdateOperation(IResource[] resources, Revision selectedRevision, boolean doRecursiveUpdate) {
        super("Operation.Update", resources);
        this.selectedRevision = selectedRevision == null ? Revision.HEAD : selectedRevision;
        this.doRecursiveUpdate = doRecursiveUpdate;
    }

    public IResource[] getResources() {
        return this.getProcessed();
    }

    protected void runImpl(final IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        this.defineInitialResourceSet(resources);
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        Map wc2Resources = SVNUtility.splitWorkingCopies(resources);
        Iterator it = wc2Resources.entrySet().iterator();
        while (it.hasNext() && !monitor.isCanceled()) {
            Map.Entry entry = it.next();
            final IRepositoryLocation location = storage.getRepositoryLocation((IResource)((IProject)entry.getKey()));
            IResource[] wcResources = ((List)entry.getValue()).toArray(new IResource[0]);
            if (this.doRecursiveUpdate) {
                wcResources = FileUtility.shrinkChildNodes(wcResources);
            } else {
                FileUtility.reorder(wcResources, true);
            }
            final String[] paths = FileUtility.asPathArray(wcResources);
            this.complexWriteToConsole(new Runnable(){

                public void run() {
                    UpdateOperation.this.writeToConsole(0, "svn update");
                    int i = 0;
                    while (i < paths.length && !monitor.isCanceled()) {
                        UpdateOperation.this.writeToConsole(0, " \"" + paths[i] + "\"");
                        ++i;
                    }
                    UpdateOperation.this.writeToConsole(0, " -r " + UpdateOperation.this.selectedRevision + (UpdateOperation.this.doRecursiveUpdate ? "" : " -N") + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                }
            });
            final ISVNClientWrapper proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.update(paths, UpdateOperation.this.selectedRevision, UpdateOperation.this.doRecursiveUpdate, false, new ConflictDetectionProgressMonitor(UpdateOperation.this, monitor, null));
                }
            }, monitor, wc2Resources.size());
            location.releaseSVNProxy(proxy);
        }
    }

    protected class ConflictDetectionProgressMonitor
    extends SVNProgressMonitor {
        public ConflictDetectionProgressMonitor(IActionOperation parent, IProgressMonitor monitor, IPath root) {
            super(parent, monitor, root);
        }

        public void progress(int current, int total, ISVNProgressMonitor.ItemState state) {
            super.progress(current, total, state);
            if (state.contentState == 8 || state.propState == 8) {
                UpdateOperation.this.hasUnresolvedConflict = true;
                Iterator it = UpdateOperation.this.processed.iterator();
                while (it.hasNext()) {
                    IResource conflictResource;
                    IResource res = (IResource)it.next();
                    Path conflictPath = new Path(state.path);
                    IPath resourcePath = FileUtility.getResourcePath(res);
                    if (!resourcePath.isPrefixOf((IPath)conflictPath)) continue;
                    if (resourcePath.equals((Object)conflictPath)) {
                        it.remove();
                    }
                    if ((conflictResource = ResourcesPlugin.getWorkspace().getRoot().findMember(res.getFullPath().append(conflictPath.removeFirstSegments(resourcePath.segmentCount())))) == null) break;
                    UpdateOperation.this.unprocessed.add(conflictResource);
                    break;
                }
            }
        }
    }
}

