/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.core.RepositoryProvider;
import org.polarion.team.svn.core.IConnectedProjectInformation;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IRepositoryResource;
import org.polarion.team.svn.core.resource.IRepositoryResourceProvider;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.SVNUtility;

public class SwitchOperation
extends AbstractRepositoryOperation {
    protected IResource[] resources;

    public SwitchOperation(IResource[] resources, IRepositoryResourceProvider destination) {
        super("Operation.Switch", destination);
        this.resources = resources;
    }

    public SwitchOperation(IResource[] resources, IRepositoryResource[] destination) {
        super("Operation.Switch", destination);
        this.resources = resources;
    }

    public ISchedulingRule getSchedulingRule() {
        HashSet<IResource> ruleSet = new HashSet<IResource>();
        int i = 0;
        while (i < this.resources.length) {
            ruleSet.add((IResource)(this.resources[i] instanceof IProject ? this.resources[i] : this.resources[i].getParent()));
            ++i;
        }
        return new MultiRule((ISchedulingRule[])ruleSet.toArray(new IResource[ruleSet.size()]));
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] destinations = this.operableData();
        int i = 0;
        while (i < this.resources.length) {
            final IResource resource = this.resources[i];
            final IRepositoryResource destination = destinations[i];
            final IRepositoryLocation location = destination.getRepositoryLocation();
            final ISVNClientWrapper proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    String wcPath = FileUtility.getWorkingCopyPath(resource);
                    SwitchOperation.this.writeToConsole(0, "svn switch \"" + destination.getUrl() + "\" \"" + FileUtility.normalizePath(wcPath) + "\" -r " + destination.getSelectedRevision() + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                    proxy.doSwitch(wcPath, SVNUtility.encodeURL(destination.getUrl()), destination.getSelectedRevision(), true, new SVNProgressMonitor(SwitchOperation.this, monitor, null));
                    if (resource instanceof IProject) {
                        IConnectedProjectInformation provider = (IConnectedProjectInformation)RepositoryProvider.getProvider((IProject)((IProject)resource));
                        provider.switchResource(destination);
                    }
                }
            }, monitor, 0);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }
}

