/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local;

import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.SVNTeamPlugin;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.utility.FileUtility;
import org.polarion.team.svn.core.utility.PatternProvider;
import org.polarion.team.svn.core.utility.SVNUtility;

public class SaveProjectMetaOperation
extends AbstractWorkingCopyOperation
implements IResourceProvider {
    protected static final String[] META_FILES = new String[]{".project", ".classpath"};
    protected HashMap savedMetas = new HashMap();
    protected String startsWith;

    public SaveProjectMetaOperation(IResource[] resources) {
        this(resources, null);
    }

    public SaveProjectMetaOperation(IResource[] resources, String startsWith) {
        super("Operation.SaveMeta", resources);
        this.startsWith = startsWith;
    }

    public SaveProjectMetaOperation(IResourceProvider provider) {
        this(provider, null);
    }

    public SaveProjectMetaOperation(IResourceProvider provider, String startsWith) {
        super("Operation.SaveMeta", provider);
        this.startsWith = startsWith;
    }

    public IResource[] getResources() {
        return this.operableData();
    }

    public Map getSavedMetas() {
        return this.savedMetas;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] changeSet = this.operableData();
        int i = 0;
        while (i < changeSet.length && !monitor.isCanceled()) {
            final IResource change = changeSet[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    IProject project = change.getProject();
                    IResource[] members = project.members();
                    int i = 0;
                    while (i < members.length && !monitor.isCanceled()) {
                        if (SaveProjectMetaOperation.this.shouldBeSaved(members[i])) {
                            try {
                                SaveProjectMetaOperation.this.saveMeta(members[i], monitor);
                            }
                            catch (Exception exception) {}
                        }
                        ++i;
                    }
                }
            }, monitor, changeSet.length);
            ++i;
        }
    }

    protected boolean shouldBeSaved(IResource resource) {
        String name = resource.getName();
        if (name.equals(SVNUtility.getSVNFolderName())) {
            return false;
        }
        if (this.startsWith != null) {
            return name.startsWith(this.startsWith);
        }
        int i = 0;
        while (i < META_FILES.length) {
            if (name.equalsIgnoreCase(META_FILES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void saveMeta(IResource resource, IProgressMonitor monitor) throws Exception {
        String sourceLocation;
        File source;
        if (resource != null && (source = new File(sourceLocation = PatternProvider.replaceAll(FileUtility.getWorkingCopyPath(resource), "\\\\", "/"))).exists()) {
            File target = File.createTempFile("save_" + resource.getName(), ".tmp", SVNTeamPlugin.instance().getStateLocation().toFile());
            target.deleteOnExit();
            if (source.isDirectory()) {
                target.delete();
                FileUtility.copyAll(target, source, 0, new FileFilter(){

                    public boolean accept(File pathname) {
                        return !pathname.getName().equals(SVNUtility.getSVNFolderName());
                    }
                }, monitor);
            } else {
                FileUtility.copyFile(target, source, monitor);
            }
            this.savedMetas.put(sourceLocation, target);
        }
    }
}

