/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.core.operation.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarion.team.svn.core.client.ISVNClientWrapper;
import org.polarion.team.svn.core.operation.IUnprotectedOperation;
import org.polarion.team.svn.core.operation.SVNProgressMonitor;
import org.polarion.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.resource.IResourceProvider;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.utility.FileUtility;

public class RevertOperation
extends AbstractWorkingCopyOperation {
    protected boolean doRecursiveRevert;

    public RevertOperation(IResource[] resources, boolean doRecursiveRevert) {
        super("Operation.Revert", resources);
        this.doRecursiveRevert = doRecursiveRevert;
    }

    public RevertOperation(IResourceProvider provider, boolean doRecursiveRevert) {
        super("Operation.Revert", provider);
        this.doRecursiveRevert = doRecursiveRevert;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        if (this.doRecursiveRevert) {
            resources = FileUtility.shrinkChildNodes(resources);
        } else {
            FileUtility.reorder(resources, false);
        }
        SVNRemoteStorage storage = SVNRemoteStorage.instance();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            IRepositoryLocation location = storage.getRepositoryLocation(resources[i]);
            final String wcPath = FileUtility.getWorkingCopyPath(resources[i]);
            final ISVNClientWrapper proxy = location.acquireSVNProxy();
            this.writeToConsole(0, "svn revert \"" + FileUtility.normalizePath(wcPath) + "\"" + (this.doRecursiveRevert ? " -R" : "") + "\n");
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    proxy.revert(wcPath, RevertOperation.this.doRecursiveRevert, new SVNProgressMonitor(RevertOperation.this, monitor, null));
                }
            }, monitor, resources.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }
}

